/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class JodaTimeConverter {
    public static final DateTime MIN_DATE_TIME = DateTime.parse((String)"0001-01-01T00:00:00Z");
    public static final LocalDate MIN_LOCAL_DATE = new LocalDate(1, 1, 1);
    private static final DateTimeFormatter localDateParser = ISODateTimeFormat.localDateParser();
    private static final DateTimeFormatter dateTimeParser = ISODateTimeFormat.dateTimeParser().withOffsetParsed();
    private static final DateTimeZone utcZone = DateTimeZone.UTC;
    static final JsonReader.ReadObject<LocalDate> LocalDateReader = new JsonReader.ReadObject<LocalDate>(){

        @Override
        public LocalDate read(JsonReader reader) throws IOException {
            return JodaTimeConverter.deserializeLocalDate(reader);
        }
    };
    static final JsonWriter.WriteObject<LocalDate> LocalDateWriter = new JsonWriter.WriteObject<LocalDate>(){

        @Override
        public void write(JsonWriter writer, LocalDate value) {
            JodaTimeConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<DateTime> DateTimeReader = new JsonReader.ReadObject<DateTime>(){

        @Override
        public DateTime read(JsonReader reader) throws IOException {
            return JodaTimeConverter.deserializeDateTime(reader);
        }
    };
    static final JsonWriter.WriteObject<DateTime> DateTimeWriter = new JsonWriter.WriteObject<DateTime>(){

        @Override
        public void write(JsonWriter writer, DateTime value) {
            JodaTimeConverter.serializeNullable(value, writer);
        }
    };

    public static void serializeNullable(DateTime value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JodaTimeConverter.serialize(value, sw);
        }
    }

    public static void serialize(DateTime value, JsonWriter sw) {
        int offset;
        byte[] buf = sw.ensureCapacity(32);
        int pos = sw.size();
        buf[pos] = 34;
        int year = value.getYear();
        NumberConverter.write4(year, buf, pos + 1);
        buf[pos + 5] = 45;
        NumberConverter.write2(value.getMonthOfYear(), buf, pos + 6);
        buf[pos + 8] = 45;
        NumberConverter.write2(value.getDayOfMonth(), buf, pos + 9);
        buf[pos + 11] = 84;
        NumberConverter.write2(value.getHourOfDay(), buf, pos + 12);
        buf[pos + 14] = 58;
        NumberConverter.write2(value.getMinuteOfHour(), buf, pos + 15);
        buf[pos + 17] = 58;
        NumberConverter.write2(value.getSecondOfMinute(), buf, pos + 18);
        int milis = value.getMillisOfSecond();
        if (milis != 0) {
            buf[pos + 20] = 46;
            int hi = milis / 100;
            int lo = milis - hi * 100;
            buf[pos + 21] = (byte)(hi + 48);
            if (lo != 0) {
                NumberConverter.write2(lo, buf, pos + 22);
                offset = 24 + JodaTimeConverter.writeTimezone(buf, pos + 24, value, sw);
            } else {
                offset = 22 + JodaTimeConverter.writeTimezone(buf, pos + 22, value, sw);
            }
        } else {
            offset = 20 + JodaTimeConverter.writeTimezone(buf, pos + 20, value, sw);
        }
        sw.advance(offset);
    }

    private static int writeTimezone(byte[] buf, int position, DateTime dt, JsonWriter sw) {
        DateTimeZone zone = dt.getZone();
        if (utcZone.equals((Object)zone) || zone == null) {
            buf[position] = 90;
            buf[position + 1] = 34;
            return 2;
        }
        long ms = dt.getMillis();
        int off = zone.getOffset(ms);
        if (off < 0) {
            buf[position] = 45;
            off = -off;
        } else {
            buf[position] = 43;
        }
        int hours = off / 3600000;
        int remainder = off - hours * 3600000;
        NumberConverter.write2(hours, buf, position + 1);
        buf[position + 3] = 58;
        NumberConverter.write2(remainder / 60000, buf, position + 4);
        buf[position + 6] = 34;
        return 7;
    }

    public static DateTime deserializeDateTime(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len > 18 && len < 25 && tmp[len - 1] == 'Z' && tmp[4] == '-' && tmp[7] == '-' && (tmp[10] == 'T' || tmp[10] == 't' || tmp[10] == ' ') && tmp[13] == ':' && tmp[16] == ':') {
            int year = NumberConverter.read4(tmp, 0);
            int month = NumberConverter.read2(tmp, 5);
            int day = NumberConverter.read2(tmp, 8);
            int hour = NumberConverter.read2(tmp, 11);
            int min = NumberConverter.read2(tmp, 14);
            int sec = NumberConverter.read2(tmp, 17);
            if (tmp[19] == '.') {
                int milis;
                switch (len) {
                    case 22: {
                        milis = 100 * (tmp[20] - 48);
                        break;
                    }
                    case 23: {
                        milis = 100 * (tmp[20] - 48) + 10 * (tmp[21] - 48);
                        break;
                    }
                    default: {
                        milis = 100 * (tmp[20] - 48) + 10 * (tmp[21] - 48) + tmp[22] - 48;
                    }
                }
                return new DateTime(year, month, day, hour, min, sec, milis, utcZone);
            }
            return new DateTime(year, month, day, hour, min, sec, 0, utcZone);
        }
        return dateTimeParser.parseDateTime(new String(tmp, 0, len));
    }

    public static ArrayList<DateTime> deserializeDateTimeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(DateTimeReader);
    }

    public static void deserializeDateTimeCollection(JsonReader reader, Collection<DateTime> res) throws IOException {
        reader.deserializeCollection(DateTimeReader, res);
    }

    public static ArrayList<DateTime> deserializeDateTimeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(DateTimeReader);
    }

    public static void deserializeDateTimeNullableCollection(JsonReader reader, Collection<DateTime> res) throws IOException {
        reader.deserializeNullableCollection(DateTimeReader, res);
    }

    public static void serializeNullable(LocalDate value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            JodaTimeConverter.serialize(value, sw);
        }
    }

    public static void serialize(LocalDate value, JsonWriter sw) {
        byte[] buf = sw.ensureCapacity(12);
        int pos = sw.size();
        buf[pos] = 34;
        int year = value.getYear();
        NumberConverter.write4(year, buf, pos + 1);
        buf[pos + 5] = 45;
        NumberConverter.write2(value.getMonthOfYear(), buf, pos + 6);
        buf[pos + 8] = 45;
        NumberConverter.write2(value.getDayOfMonth(), buf, pos + 9);
        buf[pos + 11] = 34;
        sw.advance(12);
    }

    public static LocalDate deserializeLocalDate(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len == 10 && tmp[4] == '-' && tmp[7] == '-') {
            int year = NumberConverter.read4(tmp, 0);
            int month = NumberConverter.read2(tmp, 5);
            int day = NumberConverter.read2(tmp, 8);
            return new LocalDate(year, month, day);
        }
        return localDateParser.parseLocalDate(new String(tmp, 0, len));
    }

    public static ArrayList<LocalDate> deserializeLocalDateCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LocalDateReader);
    }

    public static void deserializeLocalDateCollection(JsonReader reader, Collection<LocalDate> res) throws IOException {
        reader.deserializeCollection(LocalDateReader, res);
    }

    public static ArrayList<LocalDate> deserializeLocalDateNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LocalDateReader);
    }

    public static void deserializeLocalDateNullableCollection(JsonReader reader, Collection<LocalDate> res) throws IOException {
        reader.deserializeNullableCollection(LocalDateReader, res);
    }
}

