/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.Base64;
import com.dslplatform.json.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class JsonReader<TContext> {
    private static final boolean[] WHITESPACE = new boolean[256];
    private int tokenStart;
    private int nameEnd;
    protected int currentIndex = 0;
    private long currentPosition = 0L;
    private byte last = (byte)32;
    private int length;
    private final char[] tmp;
    final int tmpLength;
    public final TContext context;
    protected final byte[] buffer;
    protected char[] chars;
    private static final Charset UTF_8;

    protected JsonReader(char[] tmp, byte[] buffer, int length, TContext context) {
        this.tmp = tmp;
        this.tmpLength = tmp.length;
        this.buffer = buffer;
        this.length = length;
        this.context = context;
        this.chars = tmp;
    }

    public JsonReader(byte[] buffer, TContext context) {
        this(new char[64], buffer, buffer.length, context);
    }

    public JsonReader(byte[] buffer, TContext context, char[] tmp) {
        this(tmp, buffer, buffer.length, context);
        if (tmp == null) {
            throw new NullPointerException("tmp buffer provided as null.");
        }
    }

    public JsonReader(byte[] buffer, int length, TContext context) throws IOException {
        this(buffer, length, context, new char[64]);
    }

    public JsonReader(byte[] buffer, int length, TContext context, char[] tmp) throws IOException {
        this(tmp, buffer, length, context);
        if (tmp == null) {
            throw new NullPointerException("tmp buffer provided as null.");
        }
        if (length > buffer.length) {
            throw new IOException("length can't be longer than buffer.length");
        }
        if (length < buffer.length) {
            buffer[length] = 0;
        }
    }

    public final int length() {
        return this.length;
    }

    void reset(int newLength) {
        this.currentPosition += (long)this.currentIndex;
        this.currentIndex = 0;
        this.length = newLength;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, UTF_8);
    }

    public byte read() throws IOException {
        if (this.currentIndex >= this.length) {
            throw new IOException("Unexpected end of JSON input");
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    boolean isEndOfStream() throws IOException {
        return this.length == this.currentIndex;
    }

    public final byte last() {
        return this.last;
    }

    final IOException expecting(String what) {
        return new IOException("Expecting '" + what + "' at position " + this.positionInStream() + ". Found " + (char)this.last);
    }

    final IOException expecting(String what, byte found) {
        return new IOException("Expecting '" + what + "' at position " + this.positionInStream() + ". Found " + (char)found);
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    public final char[] readNumber() {
        this.tokenStart = this.currentIndex - 1;
        this.tmp[0] = (char)this.last;
        int i = 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        while (i < this.tmp.length && ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93) {
            this.tmp[i++] = (char)bb;
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tmp;
    }

    public final int scanNumber() {
        int i;
        this.tokenStart = this.currentIndex - 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        for (i = 1; i < this.tmp.length && ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93; ++i) {
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tokenStart;
    }

    final char[] prepareBuffer(int start) {
        char[] _tmp = this.tmp;
        byte[] _buf = this.buffer;
        int max = Math.min(_tmp.length, _buf.length - start);
        for (int i = 0; i < max; ++i) {
            _tmp[i] = (char)_buf[start + i];
        }
        return _tmp;
    }

    public final String readSimpleString() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int i = 0;
        int ci = this.currentIndex;
        try {
            byte bb;
            while (i < this.tmp.length && (bb = this.buffer[ci++]) != 34) {
                this.tmp[i++] = (char)bb;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.positionInStream());
        }
        if (ci > this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + (this.currentPosition + (long)this.length));
        }
        this.currentIndex = ci;
        return new String(this.tmp, 0, i);
    }

    public final char[] readSimpleQuote() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int ci = this.tokenStart = this.currentIndex;
        try {
            byte bb;
            for (int i = 0; i < this.tmp.length && (bb = this.buffer[ci++]) != 34; ++i) {
                this.tmp[i] = (char)bb;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.positionInStream());
        }
        if (ci > this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + (this.currentPosition + (long)this.length));
        }
        this.currentIndex = ci;
        return this.tmp;
    }

    public final String readString() throws IOException {
        int startIndex = this.currentIndex;
        if (this.last != 34) {
            throw new IOException("JSON string must start with a double quote at: " + this.positionInStream());
        }
        byte bb = 0;
        int ci = this.currentIndex;
        try {
            for (int i = 0; i < this.chars.length; ++i) {
                if ((bb = this.buffer[ci++]) == 34) {
                    this.currentIndex = ci;
                    return new String(this.chars, 0, i);
                }
                if ((bb ^ 0x5C) >= 1) {
                    this.chars[i] = (char)bb;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new IOException("JSON string was not closed with a double quote at: " + this.positionInStream());
        }
        if (ci >= this.length) {
            throw new IOException("JSON string was not closed with a double quote at: " + (this.currentPosition + (long)this.length));
        }
        this.currentIndex = ci;
        int soFar = --this.currentIndex - startIndex;
        while (!this.isEndOfStream()) {
            int bc;
            block29: {
                block28: {
                    bc = this.read();
                    if (bc == 34) {
                        return new String(this.chars, 0, soFar);
                    }
                    if (soFar >= this.chars.length - 3) {
                        this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
                    }
                    if (bc != 92) break block28;
                    bc = this.buffer[this.currentIndex++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block29;
                        }
                        case 116: {
                            bc = 9;
                            break block29;
                        }
                        case 110: {
                            bc = 10;
                            break block29;
                        }
                        case 102: {
                            bc = 12;
                            break block29;
                        }
                        case 114: {
                            bc = 13;
                            break block29;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block29;
                        }
                        case 117: {
                            bc = (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 12) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 8) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 4) + JsonReader.hexToInt(this.buffer[this.currentIndex++]);
                            break block29;
                        }
                        default: {
                            throw new IOException("Could not parse String at position: " + this.positionInStream() + ". Invalid escape combination detected: '\\" + bc + "'");
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    byte u2 = this.buffer[this.currentIndex++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = this.buffer[this.currentIndex++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = this.buffer[this.currentIndex++];
                            if ((bc & 0xF8) != 240) {
                                throw new IOException("Invalid unicode character detected at: " + this.positionInStream());
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw new IOException("Invalid unicode character detected at: " + this.positionInStream());
                                }
                                int sup = bc - 65536;
                                this.chars[soFar++] = (char)((sup >>> 10) + 55296);
                                this.chars[soFar++] = (char)((sup & 0x3FF) + 56320);
                            }
                        }
                    }
                }
            }
            this.chars[soFar++] = (char)bc;
        }
        throw new IOException("JSON string was not closed with a double quote at: " + this.positionInStream());
    }

    private static int hexToInt(byte value) throws IOException {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 65 && value <= 70) {
            return value - 55;
        }
        if (value >= 97 && value <= 102) {
            return value - 87;
        }
        throw new IOException("Could not parse unicode escape, expected a hexadecimal digit, got '" + value + "'");
    }

    private boolean wasWhiteSpace() {
        switch (this.last) {
            case -96: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
            case -31: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -102 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
            case -30: {
                if (this.currentIndex + 1 < this.length) {
                    byte b1 = this.buffer[this.currentIndex];
                    byte b2 = this.buffer[this.currentIndex + 1];
                    if (b1 == -127 && b2 == -97) {
                        this.currentIndex += 2;
                        this.last = (byte)32;
                        return true;
                    }
                    if (b1 != -128) {
                        return false;
                    }
                    switch (b2) {
                        case -128: 
                        case -127: 
                        case -126: 
                        case -125: 
                        case -124: 
                        case -123: 
                        case -122: 
                        case -121: 
                        case -120: 
                        case -119: 
                        case -118: 
                        case -88: 
                        case -87: 
                        case -81: {
                            this.currentIndex += 2;
                            this.last = (byte)32;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case -29: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -128 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public final byte getNextToken() throws IOException {
        this.read();
        if (WHITESPACE[this.last + 128]) {
            while (this.wasWhiteSpace()) {
                this.read();
            }
        }
        return this.last;
    }

    public final long positionInStream() {
        return this.currentPosition + (long)this.currentIndex;
    }

    public final long positionInStream(int offset) {
        return this.currentPosition + (long)this.currentIndex - (long)offset;
    }

    public final int fillName() throws IOException {
        byte b;
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.tokenStart = this.currentIndex;
        int ci = this.currentIndex;
        long hash = -2128831035L;
        while (ci < this.buffer.length && (b = this.buffer[ci++]) != 34) {
            hash ^= (long)b;
            hash *= 16777619L;
        }
        this.nameEnd = this.currentIndex = ci;
        if (!(this.read() == 58 || this.wasWhiteSpace() && this.getNextToken() == 58)) {
            throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return (int)hash;
    }

    public final int calcHash() throws IOException {
        byte b;
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.tokenStart = this.currentIndex;
        int ci = this.currentIndex;
        long hash = -2128831035L;
        while (ci < this.buffer.length && (b = this.buffer[ci++]) != 34) {
            hash ^= (long)b;
            hash *= 16777619L;
        }
        this.currentIndex = ci;
        return (int)hash;
    }

    public final boolean wasLastName(String name) {
        if (name.length() != this.nameEnd - this.tokenStart - 1) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == this.buffer[this.tokenStart + i]) continue;
            return false;
        }
        return true;
    }

    public final String getLastName() throws IOException {
        return new String(this.buffer, this.tokenStart, this.currentIndex - this.tokenStart - 1, "ISO-8859-1");
    }

    private byte skipString() throws IOException {
        byte c;
        byte prev = c = this.read();
        while (c != 34 || prev == 92) {
            prev = c;
            c = this.read();
        }
        return this.getNextToken();
    }

    public final byte skip() throws IOException {
        if (this.last == 34) {
            return this.skipString();
        }
        if (this.last == 123) {
            byte nextToken = this.getNextToken();
            if (nextToken == 125) {
                return this.getNextToken();
            }
            if (nextToken != 34) {
                throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)nextToken);
            }
            nextToken = this.skipString();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)nextToken);
            }
            this.getNextToken();
            nextToken = this.skip();
            while (nextToken == 44) {
                nextToken = this.getNextToken();
                if (nextToken != 34) {
                    throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)nextToken);
                }
                nextToken = this.skipString();
                if (nextToken != 58) {
                    throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)nextToken);
                }
                this.getNextToken();
                nextToken = this.skip();
            }
            if (nextToken != 125) {
                throw new IOException("Expecting '}' at position " + this.positionInStream() + ". Found " + (char)nextToken);
            }
            return this.getNextToken();
        }
        if (this.last == 91) {
            this.getNextToken();
            byte nextToken = this.skip();
            while (nextToken == 44) {
                this.getNextToken();
                nextToken = this.skip();
            }
            if (nextToken != 93) {
                throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)nextToken);
            }
            return this.getNextToken();
        }
        if (this.last == 110) {
            if (!this.wasNull()) {
                throw new IOException("Expecting 'null' at position " + this.positionInStream());
            }
            return this.getNextToken();
        }
        if (this.last == 116) {
            if (!this.wasTrue()) {
                throw new IOException("Expecting 'true' at position " + this.positionInStream());
            }
            return this.getNextToken();
        }
        if (this.last == 102) {
            if (!this.wasFalse()) {
                throw new IOException("Expecting 'false' at position " + this.positionInStream());
            }
            return this.getNextToken();
        }
        while (this.last != 44 && this.last != 125 && this.last != 93) {
            this.read();
        }
        return this.last;
    }

    public String readNext() throws IOException {
        int start = this.currentIndex - 1;
        this.skip();
        return new String(this.buffer, start, this.currentIndex - start - 1, "UTF-8");
    }

    public byte[] readBase64() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + " at base64 start. Found " + (char)this.last);
        }
        int start = this.currentIndex;
        this.currentIndex = Base64.findEnd(this.buffer, start);
        this.last = this.buffer[this.currentIndex++];
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + " at base64 end. Found " + (char)this.last);
        }
        return Base64.decodeFast(this.buffer, start, this.currentIndex - 1);
    }

    public final boolean wasNull() throws IOException {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                this.last = (byte)108;
                return true;
            }
            throw new IOException("Invalid null value found at: " + this.positionInStream());
        }
        return false;
    }

    public final boolean wasTrue() throws IOException {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.positionInStream());
        }
        return false;
    }

    public final boolean wasFalse() throws IOException {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 3] == 101) {
                this.currentIndex += 4;
                this.last = (byte)101;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.positionInStream());
        }
        return false;
    }

    public final void checkArrayEnd() throws IOException {
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of JSON in collection at: " + this.positionInStream());
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
    }

    public final <T, S extends T> ArrayList<T> deserializeCollection(ReadObject<S> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeCollection(readObject, res);
        return res;
    }

    public final <T, S extends T> void deserializeCollection(ReadObject<S> readObject, Collection<T> res) throws IOException {
        res.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T, S extends T> ArrayList<T> deserializeNullableCollection(ReadObject<S> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeNullableCollection(readObject, res);
        return res;
    }

    public final <T, S extends T> void deserializeNullableCollection(ReadObject<S> readObject, Collection<T> res) throws IOException {
        if (this.wasNull()) {
            res.add(null);
        } else {
            res.add(readObject.read(this));
        }
        while (this.getNextToken() == 44) {
            this.getNextToken();
            if (this.wasNull()) {
                res.add(null);
                continue;
            }
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeCollection(ReadJsonObject<T> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeCollection(readObject, res);
        return res;
    }

    public final <T extends JsonObject> void deserializeCollection(ReadJsonObject<T> readObject, Collection<T> res) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            res.add(readObject.deserialize(this));
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                res.add(readObject.deserialize(this));
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeNullableCollection(ReadJsonObject<T> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeNullableCollection(readObject, res);
        return res;
    }

    public final <T extends JsonObject> void deserializeNullableCollection(ReadJsonObject<T> readObject, Collection<T> res) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            res.add(readObject.deserialize(this));
        } else if (this.wasNull()) {
            res.add(null);
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                res.add(readObject.deserialize(this));
                continue;
            }
            if (this.wasNull()) {
                res.add(null);
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.checkArrayEnd();
    }

    static {
        JsonReader.WHITESPACE[137] = true;
        JsonReader.WHITESPACE[138] = true;
        JsonReader.WHITESPACE[139] = true;
        JsonReader.WHITESPACE[140] = true;
        JsonReader.WHITESPACE[141] = true;
        JsonReader.WHITESPACE[160] = true;
        JsonReader.WHITESPACE[32] = true;
        JsonReader.WHITESPACE[97] = true;
        JsonReader.WHITESPACE[98] = true;
        JsonReader.WHITESPACE[99] = true;
        UTF_8 = Charset.forName("UTF-8");
    }

    public static interface ReadJsonObject<T extends JsonObject> {
        public T deserialize(JsonReader var1) throws IOException;
    }

    public static interface ReadObject<T> {
        public T read(JsonReader var1) throws IOException;
    }
}

