/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.Base64;
import com.dslplatform.json.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;

public class JsonStreamReader<TContext>
extends JsonReader<TContext> {
    private InputStream stream;
    private int halfLength;

    public JsonStreamReader(InputStream stream, byte[] buffer, TContext context) throws IOException {
        super(new char[64], buffer, JsonStreamReader.readFully(buffer, stream, 0), context);
        if (stream == null) {
            throw new NullPointerException("stream provided as null.");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer provided as null.");
        }
        this.stream = stream;
        this.halfLength = this.length() / 2;
    }

    public static int readFully(byte[] buffer, InputStream stream, int offset) throws IOException {
        int position;
        int read;
        for (position = offset; position < buffer.length && (read = stream.read(buffer, position, buffer.length - position)) != -1; position += read) {
        }
        return position;
    }

    @Override
    public void reset(int newLength) {
        this.halfLength = newLength / 2;
        super.reset(newLength);
    }

    @Override
    public byte read() throws IOException {
        if (this.currentIndex > this.halfLength) {
            int len = this.buffer.length - this.currentIndex;
            System.arraycopy(this.buffer, this.currentIndex, this.buffer, 0, len);
            int position = JsonStreamReader.readFully(this.buffer, this.stream, len);
            if (position == len) {
                super.reset(this.length() - this.currentIndex);
            } else {
                super.reset(position);
            }
        }
        return super.read();
    }

    @Override
    boolean isEndOfStream() throws IOException {
        if (this.length() != this.currentIndex) {
            return false;
        }
        int len = this.buffer.length - this.currentIndex;
        System.arraycopy(this.buffer, this.currentIndex, this.buffer, 0, len);
        int position = JsonStreamReader.readFully(this.buffer, this.stream, len);
        if (position == len) {
            return true;
        }
        super.reset(position);
        return super.isEndOfStream();
    }

    @Override
    public byte[] readBase64() throws IOException {
        if (Base64.findEnd(this.buffer, this.currentIndex) == this.buffer.length) {
            String input = this.readString();
            return DatatypeConverter.parseBase64Binary((String)input);
        }
        return super.readBase64();
    }

    InputStream streamFromStart() throws IOException {
        return new RereadStream(this.buffer, this.stream);
    }

    private static class RereadStream
    extends InputStream {
        private final byte[] buffer;
        private final InputStream stream;
        private boolean usingBuffer;
        private int position;

        RereadStream(byte[] buffer, InputStream stream) {
            this.buffer = buffer;
            this.stream = stream;
            this.usingBuffer = true;
        }

        @Override
        public int read() throws IOException {
            if (this.usingBuffer) {
                if (this.position < this.buffer.length) {
                    return this.buffer[this.position++];
                }
                this.usingBuffer = false;
            }
            return this.stream.read();
        }

        @Override
        public int read(byte[] buf) throws IOException {
            if (this.usingBuffer) {
                return super.read(buf);
            }
            return this.stream.read(buf);
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.usingBuffer) {
                return super.read(buf, off, len);
            }
            return this.stream.read(buf, off, len);
        }
    }
}

