/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.Base64;
import com.dslplatform.json.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class JsonWriter
extends Writer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private int position;
    private byte[] result;
    public static final byte OBJECT_START = 123;
    public static final byte OBJECT_END = 125;
    public static final byte ARRAY_START = 91;
    public static final byte ARRAY_END = 93;
    public static final byte COMMA = 44;
    public static final byte SEMI = 58;
    public static final byte QUOTE = 34;
    public static final byte ESCAPE = 92;

    final byte[] ensureCapacity(int free) {
        if (this.position + free >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + (this.result.length << 1) + free);
        }
        return this.result;
    }

    void advance(int size) {
        this.position += size;
    }

    public JsonWriter() {
        this(512);
    }

    public JsonWriter(int size) {
        this(new byte[size]);
    }

    public JsonWriter(byte[] result) {
        this.result = result;
    }

    public final void writeNull() {
        int s = this.position;
        this.position += 4;
        if (this.position >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        byte[] _result = this.result;
        _result[s] = 110;
        _result[s + 1] = 117;
        _result[s + 2] = 108;
        _result[s + 3] = 108;
    }

    public final void writeByte(byte c) {
        if (this.position == this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2);
        }
        this.result[this.position++] = c;
    }

    public final void writeString(String str) {
        int len = str.length();
        if (this.position + (len << 2) + (len << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (len << 2) + (len << 1) + 2);
        }
        byte[] _result = this.result;
        _result[this.position] = 34;
        int cur = this.position + 1;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                this.writeQuotedString(str, i, cur, len);
                return;
            }
            _result[cur++] = (byte)c;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    private void writeQuotedString(String str, int i, int cur, int len) {
        byte[] _result = this.result;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\"') {
                _result[cur++] = 92;
                _result[cur++] = 34;
            } else if (c == '\\') {
                _result[cur++] = 92;
                _result[cur++] = 92;
            } else if (c < ' ') {
                if (c == '\b') {
                    _result[cur++] = 92;
                    _result[cur++] = 98;
                } else if (c == '\t') {
                    _result[cur++] = 92;
                    _result[cur++] = 116;
                } else if (c == '\n') {
                    _result[cur++] = 92;
                    _result[cur++] = 110;
                } else if (c == '\f') {
                    _result[cur++] = 92;
                    _result[cur++] = 102;
                } else if (c == '\r') {
                    _result[cur++] = 92;
                    _result[cur++] = 114;
                } else {
                    _result[cur] = 92;
                    _result[cur + 1] = 117;
                    _result[cur + 2] = 48;
                    _result[cur + 3] = 48;
                    switch (c) {
                        case '\u0000': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0001': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0002': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0003': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0004': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0005': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0006': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0007': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u000b': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u000e': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 69;
                            break;
                        }
                        case '\u000f': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 70;
                            break;
                        }
                        case '\u0010': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0011': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0012': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0013': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0014': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0015': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0016': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0017': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u0018': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 56;
                            break;
                        }
                        case '\u0019': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 57;
                            break;
                        }
                        case '\u001a': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 65;
                            break;
                        }
                        case '\u001b': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u001c': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 67;
                            break;
                        }
                        case '\u001d': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 68;
                            break;
                        }
                        case '\u001e': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 69;
                            break;
                        }
                        default: {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 70;
                        }
                    }
                    cur += 6;
                }
            } else if (c < '\u007f') {
                _result[cur++] = (byte)c;
            } else {
                int cp = str.codePointAt(i);
                if (Character.isSupplementaryCodePoint(cp)) {
                    ++i;
                }
                if (cp == 127) {
                    _result[cur++] = (byte)cp;
                } else if (cp <= 2047) {
                    _result[cur++] = (byte)(0xC0 | cp >> 6 & 0x1F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp < 55296 || cp > 57343 && cp <= 65533) {
                    _result[cur++] = (byte)(0xE0 | cp >> 12 & 0xF);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp >= 65536 && cp <= 0x10FFFF) {
                    _result[cur++] = (byte)(0xF0 | cp >> 18 & 7);
                    _result[cur++] = (byte)(0x80 | cp >> 12 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else {
                    throw new RuntimeException("Unknown unicode codepoint in string! " + Integer.toHexString(cp));
                }
            }
            ++i;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    public final void writeAscii(String str) {
        int len = str.length();
        if (this.position + len >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + len);
        }
        str.getBytes(0, len, this.result, this.position);
        this.position += len;
    }

    public final void writeAscii(String str, int len) {
        if (this.position + len >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + len);
        }
        str.getBytes(0, len, this.result, this.position);
        this.position += len;
    }

    public final void writeAscii(byte[] buf) {
        int len = buf.length;
        if (this.position + len >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + len);
        }
        int p = this.position;
        byte[] _result = this.result;
        for (int i = 0; i < buf.length; ++i) {
            _result[p + i] = buf[i];
        }
        this.position += len;
    }

    public final void writeAscii(byte[] buf, int len) {
        if (this.position + len >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + len);
        }
        int p = this.position;
        byte[] _result = this.result;
        for (int i = 0; i < len; ++i) {
            _result[p + i] = buf[i];
        }
        this.position += len;
    }

    public final void writeBinary(byte[] buf) {
        if (this.position + (buf.length << 1) + 2 >= this.result.length) {
            this.result = Arrays.copyOf(this.result, this.result.length + this.result.length / 2 + (buf.length << 1) + 2);
        }
        this.result[this.position++] = 34;
        this.position += Base64.encodeToBytes(buf, this.result, this.position);
        this.result[this.position++] = 34;
    }

    public String toString() {
        return new String(this.result, 0, this.position, UTF_8);
    }

    public final byte[] toByteArray() {
        return Arrays.copyOf(this.result, this.position);
    }

    public final void toStream(OutputStream stream) throws IOException {
        stream.write(this.result, 0, this.position);
    }

    public final byte[] getByteBuffer() {
        return this.result;
    }

    public final int size() {
        return this.position;
    }

    public final void reset() {
        this.position = 0;
    }

    @Override
    public void write(int c) throws IOException {
        if (c < 127) {
            this.writeByte((byte)c);
        } else {
            this.write(new char[]{(char)c}, 0, 1);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        String append = new String(cbuf, off, len);
        this.writeAscii(append.getBytes(UTF_8));
    }

    @Override
    public void write(String str, int off, int len) {
        String append = str.substring(off, off + len);
        this.writeAscii(append.getBytes(UTF_8));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.position = 0;
    }

    public <T extends JsonObject> void serialize(T[] array) {
        this.writeByte((byte)91);
        if (array.length != 0) {
            array[0].serialize(this, false);
            for (int i = 1; i < array.length; ++i) {
                this.writeByte((byte)44);
                array[i].serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(T[] array, int len) {
        this.writeByte((byte)91);
        if (array.length != 0 && len != 0) {
            array[0].serialize(this, false);
            for (int i = 1; i < len; ++i) {
                this.writeByte((byte)44);
                array[i].serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(List<T> list) {
        this.writeByte((byte)91);
        if (list.size() != 0) {
            ((JsonObject)list.get(0)).serialize(this, false);
            for (int i = 1; i < list.size(); ++i) {
                this.writeByte((byte)44);
                ((JsonObject)list.get(i)).serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(T[] array, WriteObject<T> writer) {
        if (array == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (array.length != 0) {
            T item = array[0];
            if (item != null) {
                writer.write(this, item);
            } else {
                this.writeNull();
            }
            for (int i = 1; i < array.length; ++i) {
                this.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    writer.write(this, item);
                    continue;
                }
                this.writeNull();
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(List<T> list, WriteObject<T> writer) {
        if (list == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (list.size() != 0) {
            T item = list.get(0);
            if (item != null) {
                writer.write(this, item);
            } else {
                this.writeNull();
            }
            for (int i = 1; i < list.size(); ++i) {
                this.writeByte((byte)44);
                item = list.get(i);
                if (item != null) {
                    writer.write(this, item);
                    continue;
                }
                this.writeNull();
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(Collection<T> collection, WriteObject<T> writer) {
        if (collection == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (!collection.isEmpty()) {
            Iterator<T> it = collection.iterator();
            T item = it.next();
            if (item != null) {
                writer.write(this, item);
            } else {
                this.writeNull();
            }
            while (it.hasNext()) {
                this.writeByte((byte)44);
                item = it.next();
                if (item != null) {
                    writer.write(this, item);
                    continue;
                }
                this.writeNull();
            }
        }
        this.writeByte((byte)93);
    }

    public static interface WriteObject<T> {
        public void write(JsonWriter var1, T var2);
    }
}

