/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.Base64;
import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.Grisu3;
import com.dslplatform.json.JsonObject;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.UnknownSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public final class JsonWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private int position;
    private long flushed;
    private OutputStream target;
    private byte[] buffer;
    private final UnknownSerializer unknownSerializer;
    private final Grisu3.FastDtoaBuilder doubleBuilder = new Grisu3.FastDtoaBuilder();
    public static final byte OBJECT_START = 123;
    public static final byte OBJECT_END = 125;
    public static final byte ARRAY_START = 91;
    public static final byte ARRAY_END = 93;
    public static final byte COMMA = 44;
    public static final byte SEMI = 58;
    public static final byte QUOTE = 34;
    public static final byte ESCAPE = 92;

    final byte[] ensureCapacity(int free) {
        if (this.position + free >= this.buffer.length) {
            this.enlargeOrFlush(this.position, free);
        }
        return this.buffer;
    }

    void advance(int size) {
        this.position += size;
    }

    @Deprecated
    public JsonWriter() {
        this(512, null);
    }

    JsonWriter(@Nullable UnknownSerializer unknownSerializer) {
        this(512, unknownSerializer);
    }

    JsonWriter(int size, @Nullable UnknownSerializer unknownSerializer) {
        this(new byte[size], unknownSerializer);
    }

    JsonWriter(byte[] buffer, @Nullable UnknownSerializer unknownSerializer) {
        this.buffer = buffer;
        this.unknownSerializer = unknownSerializer;
    }

    private void enlargeOrFlush(int size, int padding) {
        if (this.target != null) {
            try {
                this.target.write(this.buffer, 0, size);
            }
            catch (IOException ex) {
                throw new SerializationException("Unable to write to target stream.", ex);
            }
            this.position = 0;
            this.flushed += (long)size;
            if (padding > this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + this.buffer.length / 2 + padding);
            }
        } else {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + this.buffer.length / 2 + padding);
        }
    }

    public final void writeNull() {
        if (this.position + 4 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, 0);
        }
        int s = this.position;
        byte[] _result = this.buffer;
        _result[s] = 110;
        _result[s + 1] = 117;
        _result[s + 2] = 108;
        _result[s + 3] = 108;
        this.position += 4;
    }

    public final void writeByte(byte value) {
        if (this.position == this.buffer.length) {
            this.enlargeOrFlush(this.position, 0);
        }
        this.buffer[this.position++] = value;
    }

    public final void writeString(String value) {
        int len = value.length();
        if (this.position + (len << 2) + (len << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (len << 2) + (len << 1) + 2);
        }
        byte[] _result = this.buffer;
        _result[this.position] = 34;
        int cur = this.position + 1;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                this.writeQuotedString(value, i, cur, len);
                return;
            }
            _result[cur++] = (byte)c;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    public final void writeString(CharSequence value) {
        int len = value.length();
        if (this.position + (len << 2) + (len << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (len << 2) + (len << 1) + 2);
        }
        byte[] _result = this.buffer;
        _result[this.position] = 34;
        int cur = this.position + 1;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                this.writeQuotedString(value, i, cur, len);
                return;
            }
            _result[cur++] = (byte)c;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    private void writeQuotedString(CharSequence str, int i, int cur, int len) {
        byte[] _result = this.buffer;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\"') {
                _result[cur++] = 92;
                _result[cur++] = 34;
            } else if (c == '\\') {
                _result[cur++] = 92;
                _result[cur++] = 92;
            } else if (c < ' ') {
                if (c == '\b') {
                    _result[cur++] = 92;
                    _result[cur++] = 98;
                } else if (c == '\t') {
                    _result[cur++] = 92;
                    _result[cur++] = 116;
                } else if (c == '\n') {
                    _result[cur++] = 92;
                    _result[cur++] = 110;
                } else if (c == '\f') {
                    _result[cur++] = 92;
                    _result[cur++] = 102;
                } else if (c == '\r') {
                    _result[cur++] = 92;
                    _result[cur++] = 114;
                } else {
                    _result[cur] = 92;
                    _result[cur + 1] = 117;
                    _result[cur + 2] = 48;
                    _result[cur + 3] = 48;
                    switch (c) {
                        case '\u0000': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0001': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0002': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0003': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0004': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0005': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0006': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0007': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u000b': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u000e': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 69;
                            break;
                        }
                        case '\u000f': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 70;
                            break;
                        }
                        case '\u0010': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0011': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0012': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0013': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0014': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0015': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0016': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0017': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u0018': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 56;
                            break;
                        }
                        case '\u0019': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 57;
                            break;
                        }
                        case '\u001a': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 65;
                            break;
                        }
                        case '\u001b': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u001c': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 67;
                            break;
                        }
                        case '\u001d': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 68;
                            break;
                        }
                        case '\u001e': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 69;
                            break;
                        }
                        default: {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 70;
                        }
                    }
                    cur += 6;
                }
            } else if (c < '\u007f') {
                _result[cur++] = (byte)c;
            } else {
                int cp = Character.codePointAt(str, i);
                if (Character.isSupplementaryCodePoint(cp)) {
                    ++i;
                }
                if (cp == 127) {
                    _result[cur++] = (byte)cp;
                } else if (cp <= 2047) {
                    _result[cur++] = (byte)(0xC0 | cp >> 6 & 0x1F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp < 55296 || cp > 57343 && cp <= 65535) {
                    _result[cur++] = (byte)(0xE0 | cp >> 12 & 0xF);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp >= 65536 && cp <= 0x10FFFF) {
                    _result[cur++] = (byte)(0xF0 | cp >> 18 & 7);
                    _result[cur++] = (byte)(0x80 | cp >> 12 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else {
                    throw new SerializationException("Unknown unicode codepoint in string! " + Integer.toHexString(cp));
                }
            }
            ++i;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    public final void writeAscii(String value) {
        int len = value.length();
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        value.getBytes(0, len, this.buffer, this.position);
        this.position += len;
    }

    public final void writeAscii(String value, int len) {
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        value.getBytes(0, len, this.buffer, this.position);
        this.position += len;
    }

    public final void writeAscii(byte[] buf) {
        int len = buf.length;
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        int p = this.position;
        byte[] _result = this.buffer;
        for (int i = 0; i < buf.length; ++i) {
            _result[p + i] = buf[i];
        }
        this.position += len;
    }

    public final void writeAscii(byte[] buf, int len) {
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        int p = this.position;
        byte[] _result = this.buffer;
        for (int i = 0; i < len; ++i) {
            _result[p + i] = buf[i];
        }
        this.position += len;
    }

    public final void writeRaw(byte[] buf, int offset, int len) {
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        System.arraycopy(buf, offset, this.buffer, this.position, len);
        this.position += len;
    }

    public final void writeBinary(byte[] value) {
        if (this.position + (value.length << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (value.length << 1) + 2);
        }
        this.buffer[this.position++] = 34;
        this.position += Base64.encodeToBytes(value, this.buffer, this.position);
        this.buffer[this.position++] = 34;
    }

    final void writeDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            this.writeAscii("\"Infinity\"");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.writeAscii("\"-Infinity\"");
        } else if (value != value) {
            this.writeAscii("\"NaN\"");
        } else if (value == 0.0) {
            this.writeAscii("0.0");
        } else if (Grisu3.tryConvert(value, this.doubleBuilder)) {
            if (this.position + 24 >= this.buffer.length) {
                this.enlargeOrFlush(this.position, 24);
            }
            int len = this.doubleBuilder.copyTo(this.buffer, this.position);
            this.position += len;
        } else {
            this.writeAscii(Double.toString(value));
        }
    }

    public String toString() {
        return new String(this.buffer, 0, this.position, UTF_8);
    }

    public final byte[] toByteArray() {
        if (this.target != null) {
            throw new ConfigurationException("Method is not available when targeting stream");
        }
        return Arrays.copyOf(this.buffer, this.position);
    }

    public final void toStream(OutputStream stream) throws IOException {
        if (this.target != null) {
            throw new ConfigurationException("Method should not be used when targeting streams. Instead use flush() to copy what's remaining in the buffer");
        }
        stream.write(this.buffer, 0, this.position);
        this.flushed += (long)this.position;
        this.position = 0;
    }

    public final byte[] getByteBuffer() {
        return this.buffer;
    }

    public final int size() {
        return this.position;
    }

    public final long flushed() {
        return this.flushed;
    }

    public final void reset() {
        this.reset(null);
    }

    public final void reset(@Nullable OutputStream stream) {
        this.position = 0;
        this.target = stream;
        this.flushed = 0L;
    }

    public final void flush() {
        if (this.target != null && this.position != 0) {
            try {
                this.target.write(this.buffer, 0, this.position);
            }
            catch (IOException ex) {
                throw new SerializationException("Unable to write to target stream.", ex);
            }
            this.flushed += (long)this.position;
            this.position = 0;
        }
    }

    @Deprecated
    public void close() throws IOException {
        if (this.target != null && this.position != 0) {
            this.target.write(this.buffer, 0, this.position);
            this.position = 0;
            this.flushed = 0L;
        }
    }

    public <T extends JsonObject> void serialize(T[] array) {
        this.writeByte((byte)91);
        if (array.length != 0) {
            array[0].serialize(this, false);
            for (int i = 1; i < array.length; ++i) {
                this.writeByte((byte)44);
                array[i].serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(T[] array, int len) {
        this.writeByte((byte)91);
        if (array.length != 0 && len != 0) {
            array[0].serialize(this, false);
            for (int i = 1; i < len; ++i) {
                this.writeByte((byte)44);
                array[i].serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T extends JsonObject> void serialize(List<T> list) {
        this.writeByte((byte)91);
        if (list.size() != 0) {
            ((JsonObject)list.get(0)).serialize(this, false);
            for (int i = 1; i < list.size(); ++i) {
                this.writeByte((byte)44);
                ((JsonObject)list.get(i)).serialize(this, false);
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(@Nullable T[] array, WriteObject<T> encoder) {
        if (array == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (array.length != 0) {
            T item = array[0];
            if (item != null) {
                encoder.write(this, item);
            } else {
                this.writeNull();
            }
            for (int i = 1; i < array.length; ++i) {
                this.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    encoder.write(this, item);
                    continue;
                }
                this.writeNull();
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(@Nullable List<T> list, WriteObject<T> encoder) {
        if (list == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (!list.isEmpty()) {
            if (list instanceof RandomAccess) {
                T item = list.get(0);
                if (item != null) {
                    encoder.write(this, item);
                } else {
                    this.writeNull();
                }
                for (int i = 1; i < list.size(); ++i) {
                    this.writeByte((byte)44);
                    item = list.get(i);
                    if (item != null) {
                        encoder.write(this, item);
                        continue;
                    }
                    this.writeNull();
                }
            } else {
                Iterator<T> iter = list.iterator();
                T item = iter.next();
                if (item != null) {
                    encoder.write(this, item);
                } else {
                    this.writeNull();
                }
                while (iter.hasNext()) {
                    this.writeByte((byte)44);
                    item = iter.next();
                    if (item != null) {
                        encoder.write(this, item);
                        continue;
                    }
                    this.writeNull();
                }
            }
        }
        this.writeByte((byte)93);
    }

    public <T> void serialize(@Nullable Collection<T> collection, WriteObject<T> encoder) {
        if (collection == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)91);
        if (!collection.isEmpty()) {
            Iterator<T> it = collection.iterator();
            T item = it.next();
            if (item != null) {
                encoder.write(this, item);
            } else {
                this.writeNull();
            }
            while (it.hasNext()) {
                this.writeByte((byte)44);
                item = it.next();
                if (item != null) {
                    encoder.write(this, item);
                    continue;
                }
                this.writeNull();
            }
        }
        this.writeByte((byte)93);
    }

    public <K, V> void serialize(@Nullable Map<K, V> map, WriteObject<K> keyEncoder, WriteObject<V> valueEncoder) {
        if (map == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)123);
        int size = map.size();
        if (size > 0) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            Map.Entry<K, V> kv = iterator.next();
            this.writeQuoted(keyEncoder, kv.getKey());
            this.writeByte((byte)58);
            valueEncoder.write(this, kv.getValue());
            for (int i = 1; i < size; ++i) {
                this.writeByte((byte)44);
                kv = iterator.next();
                this.writeQuoted(keyEncoder, kv.getKey());
                this.writeByte((byte)58);
                valueEncoder.write(this, kv.getValue());
            }
        }
        this.writeByte((byte)125);
    }

    public <T> void writeQuoted(WriteObject<T> keyWriter, T key) {
        if (key instanceof Double) {
            double value = (Double)key;
            if (Double.isNaN(value)) {
                this.writeAscii("\"NaN\"");
            } else if (value == Double.POSITIVE_INFINITY) {
                this.writeAscii("\"Infinity\"");
            } else if (value == Double.NEGATIVE_INFINITY) {
                this.writeAscii("\"-Infinity\"");
            } else {
                this.writeByte((byte)34);
                NumberConverter.serialize(value, this);
                this.writeByte((byte)34);
            }
        } else if (key instanceof Float) {
            float value = ((Float)key).floatValue();
            if (Float.isNaN(value)) {
                this.writeAscii("\"NaN\"");
            } else if (value == Float.POSITIVE_INFINITY) {
                this.writeAscii("\"Infinity\"");
            } else if (value == Float.NEGATIVE_INFINITY) {
                this.writeAscii("\"-Infinity\"");
            } else {
                this.writeByte((byte)34);
                NumberConverter.serialize(value, this);
                this.writeByte((byte)34);
            }
        } else if (key instanceof Number) {
            this.writeByte((byte)34);
            keyWriter.write(this, key);
            this.writeByte((byte)34);
        } else {
            keyWriter.write(this, key);
        }
    }

    public void serializeObject(@Nullable Object value) {
        if (value == null) {
            this.writeNull();
        } else if (this.unknownSerializer != null) {
            try {
                this.unknownSerializer.serialize(this, value);
            }
            catch (IOException ex) {
                throw new SerializationException(ex);
            }
        } else {
            throw new ConfigurationException("Unable to serialize: " + value.getClass() + ".\nCheck that JsonWriter was created through DslJson#newWriter.");
        }
    }

    public static interface WriteObject<T> {
        public void write(JsonWriter var1, @Nullable T var2);
    }
}

