/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.io.Flushable;
import net.java.html.junit.AbstractTestRunner;
import net.java.html.junit.UIListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

final class InvokeNowListener
extends RunListener {
    private final AbstractTestRunner schedule;
    private final RunListener delegate = UIListener.create().getListener();

    InvokeNowListener(AbstractTestRunner schedule) {
        this.schedule = schedule;
    }

    public void testIgnored(Description description) throws Exception {
        this.fire(1, description);
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.fire(2, failure);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        this.fire(3, failure);
    }

    public void testFinished(Description description) throws Exception {
        this.fire(4, description);
    }

    public void testStarted(Description description) throws Exception {
        this.fire(5, description);
    }

    public void testRunFinished(Result result) throws Exception {
        this.fire(6, result);
    }

    public void testRunStarted(Description description) throws Exception {
        this.fire(7, description);
    }

    private void fire(final int type, final Object parameter) throws Exception {
        this.schedule.invokeNow(new Runnable(){

            @Override
            public void run() {
                try {
                    switch (type) {
                        case 1: {
                            InvokeNowListener.this.delegate.testIgnored((Description)parameter);
                            break;
                        }
                        case 2: {
                            InvokeNowListener.this.delegate.testAssumptionFailure((Failure)parameter);
                            break;
                        }
                        case 3: {
                            InvokeNowListener.this.delegate.testFailure((Failure)parameter);
                            break;
                        }
                        case 4: {
                            InvokeNowListener.this.delegate.testFinished((Description)parameter);
                            break;
                        }
                        case 5: {
                            InvokeNowListener.this.delegate.testStarted((Description)parameter);
                            break;
                        }
                        case 6: {
                            InvokeNowListener.this.delegate.testRunFinished((Result)parameter);
                            break;
                        }
                        case 7: {
                            InvokeNowListener.this.delegate.testRunStarted((Description)parameter);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("cannot dispatch type: " + type);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (this.delegate instanceof Flushable && type == 6) {
            Result result = (Result)parameter;
            if (!result.wasSuccessful()) {
                Flushable flush = (Flushable)this.delegate;
                flush.flush();
            }
            return;
        }
    }
}

