/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.util.List;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import net.java.html.BrwsrCtx;
import net.java.html.boot.BrowserBuilder;
import net.java.html.junit.AbstractTestRunner;
import net.java.html.junit.InvokeNowListener;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;
import org.netbeans.html.boot.spi.Fn;

final class PresenterTestRunner
extends AbstractTestRunner {
    private static final Timer TIMER = new Timer("Invoke Later");
    private final String name;
    private final BrwsrCtx ctx;
    private final RunListener listener;

    PresenterTestRunner(String name, String url, Fn.Presenter p, Class<?> klass) throws InitializationError {
        this.name = name;
        this.ctx = PresenterTestRunner.initPresenter(url, p, klass);
        this.listener = new InvokeNowListener(this);
    }

    static void registerPresenters(List<? super AbstractTestRunner> ctxs, String url, Class<?> klass) throws InitializationError {
        for (Fn.Presenter p : ServiceLoader.load(Fn.Presenter.class)) {
            ctxs.add(new PresenterTestRunner(p.getClass().getSimpleName(), url, p, klass));
        }
    }

    private static BrwsrCtx initPresenter(String url, Fn.Presenter p, final Class<?> klass) throws InitializationError {
        final BrwsrCtx[] ret = new BrwsrCtx[]{null};
        final CountDownLatch cdl = new CountDownLatch(1);
        final BrowserBuilder bb = BrowserBuilder.newBrowser((Object[])new Object[]{p}).loadFinished(new Runnable(){

            @Override
            public void run() {
                ret[0] = BrwsrCtx.findDefault((Class)klass);
                cdl.countDown();
            }
        }).loadPage(url);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                bb.showAndWait();
            }
        });
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw new InitializationError((Throwable)ex);
        }
        return ret[0];
    }

    @Override
    RunListener listener() {
        return this.listener;
    }

    @Override
    void invokeNow(final Runnable run) {
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                PresenterTestRunner.this.ctx.execute(run);
            }
        }, 1L);
    }

    @Override
    void invokeLater(final Runnable run) {
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                PresenterTestRunner.this.ctx.execute(run);
            }
        }, 100L);
    }

    @Override
    String name() {
        return this.name;
    }
}

