/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.html.junit.AbstractTestRunner;
import net.java.html.junit.HTMLContent;
import net.java.html.junit.MultiNotifier;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

final class SingleBrowserRunner
extends BlockJUnit4ClassRunner {
    private final AbstractTestRunner schedule;
    private final String browser;
    private final String html;

    SingleBrowserRunner(String browser, AbstractTestRunner run, Class<?> klass) throws InitializationError {
        super(klass);
        this.browser = browser;
        this.schedule = run;
        HTMLContent content = klass.getAnnotation(HTMLContent.class);
        this.html = content != null ? content.value() : null;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List methods = super.computeTestMethods();
        ArrayList<FrameworkMethod> clone = new ArrayList<FrameworkMethod>(methods.size());
        for (int i = 0; i < methods.size(); ++i) {
            FrameworkMethod m = (FrameworkMethod)methods.get(i);
            clone.add(new InBrowserMethod(m.getMethod()));
        }
        return clone;
    }

    public void run(RunNotifier notifier) {
        MultiNotifier testNotifier = MultiNotifier.wrap(Collections.nCopies(1, this.schedule), notifier, this.getDescription());
        try {
            for (FrameworkMethod frameworkMethod : this.getChildren()) {
                this.runChild(frameworkMethod, notifier);
            }
        }
        catch (AssumptionViolatedException e) {
            testNotifier.addFailedAssumption(e);
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
    }

    protected void runChild(FrameworkMethod m, RunNotifier notifier) {
        InBrowserMethod method = (InBrowserMethod)m;
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            try {
                Object test = method.getMethod().getDeclaringClass().newInstance();
                Statement before = this.withBefores(method, test, EmptyStatement.EMPTY);
                Statement after = this.withAfters(method, test, EmptyStatement.EMPTY);
                method.invokeInSteps(notifier, description, before, test, new Object[0], after);
            }
            catch (Throwable ex) {
                notifier.fireTestFailure(new Failure(description, ex));
            }
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
    }

    private static final class EmptyStatement
    extends Statement {
        public static final Statement EMPTY = new EmptyStatement();

        private EmptyStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }

    private class InBrowserMethod
    extends FrameworkMethod {
        public InBrowserMethod(Method method) {
            super(method);
        }

        final Object explosive(Object target, Object[] params) throws Throwable {
            if (SingleBrowserRunner.this.html != null) {
                AbstractTestRunner.exposeHTML(SingleBrowserRunner.this.html);
            }
            return this.getMethod().invoke(target, params);
        }

        void invokeInSteps(final RunNotifier notifier, final Description description, final Statement before, final Object target, final Object[] params, final Statement after) {
            notifier.fireTestStarted(description);
            if (before != null) {
                SingleBrowserRunner.this.schedule.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            before.evaluate();
                        }
                        catch (Throwable ex) {
                            notifier.fireTestFailure(new Failure(description, ex));
                        }
                    }
                });
            }
            Object[] ex = new Object[]{null};
            SingleBrowserRunner.this.schedule.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Runnable> delayed = new ArrayList<Runnable>();
                    try {
                        Object ret = InBrowserMethod.this.explosive(target, params);
                        if (ret instanceof Runnable) {
                            delayed.add((Runnable)ret);
                        }
                        if (ret instanceof Runnable[]) {
                            delayed.addAll(Arrays.asList((Runnable[])ret));
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof InvocationTargetException) {
                            t = t.getCause();
                        }
                        notifier.fireTestFailure(new Failure(description, t));
                    }
                    class DelayedAndAfter
                    implements Runnable {
                        private final List<Runnable> delayed;
                        private int at;
                        private Statement atEnd;
                        final /* synthetic */ Statement val$after;
                        final /* synthetic */ RunNotifier val$notifier;
                        final /* synthetic */ Description val$description;
                        final /* synthetic */ InBrowserMethod this$1;

                        DelayedAndAfter(List<Runnable> delayed) {
                            this.this$1 = this$1;
                            this.val$after = var3_3;
                            this.val$notifier = var4_4;
                            this.val$description = var5_5;
                            this.atEnd = this.val$after;
                            this.delayed = delayed;
                            this.at = 0;
                        }

                        @Override
                        public void run() {
                            if (this.at < this.delayed.size()) {
                                try {
                                    this.delayed.get(this.at++).run();
                                }
                                catch (Throwable t) {
                                    this.at = this.delayed.size();
                                    this.val$notifier.fireTestFailure(new Failure(this.val$description, t));
                                }
                                finally {
                                    this.this$1.SingleBrowserRunner.this.schedule.invokeLater(this);
                                }
                                return;
                            }
                            if (this.atEnd != null) {
                                this.this$1.SingleBrowserRunner.this.schedule.invokeLater(this);
                                try {
                                    this.atEnd.evaluate();
                                }
                                catch (Throwable t) {
                                    this.val$notifier.fireTestAssumptionFailed(new Failure(this.val$description, t));
                                }
                                finally {
                                    this.atEnd = null;
                                }
                                return;
                            }
                            this.val$notifier.fireTestFinished(this.val$description);
                        }
                    }
                    SingleBrowserRunner.this.schedule.invokeLater(new DelayedAndAfter(InBrowserMethod.this, delayed, after, notifier, description));
                }
            });
        }
    }
}

