/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.net.URL;
import java.util.ServiceLoader;
import org.junit.runner.notification.RunListener;

final class UIListener {
    private final RunListener listener;
    private final URL page;
    private final String resource;

    private UIListener(RunListener listener, URL page, String resource) {
        this.listener = listener;
        this.page = page;
        this.resource = resource;
    }

    RunListener getListener() {
        return this.listener;
    }

    URL getPage() {
        return this.page;
    }

    String getResource() {
        return this.resource;
    }

    static UIListener create() {
        try {
            for (RunListener listener : ServiceLoader.load(RunListener.class)) {
                int last;
                String fqnSlash;
                String name;
                Class<?> listenerClass = listener.getClass();
                URL dynamicURL = listenerClass.getResource(name = (fqnSlash = listenerClass.getName().replace('.', '/')).substring(last = fqnSlash.lastIndexOf(47) + 1) + ".html");
                if (dynamicURL == null) continue;
                String resource = fqnSlash.substring(0, last) + name;
                return new UIListener(listener, dynamicURL, resource);
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        String resource = "/net/java/html/junit/runner.html";
        URL url = UIListener.class.getResource("runner.html");
        return new UIListener(new RunListener(), url, resource);
    }
}

