/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public abstract class DocLint
implements Plugin {
    public static final String XMSGS_OPTION = "-Xmsgs";
    public static final String XMSGS_CUSTOM_PREFIX = "-Xmsgs:";
    public static final String XCHECK_PACKAGE = "-XcheckPackage:";

    public abstract boolean isValidOption(String var1);

    public static synchronized DocLint newDocLint() {
        Provider<DocLint> provider = new Provider<DocLint>(){

            @Override
            public Class<? extends DocLint> type() {
                return NoDocLint.class;
            }

            @Override
            public DocLint get() {
                return new NoDocLint();
            }
        };
        for (DocLint docLint : ServiceLoader.load(DocLint.class, ClassLoader.getSystemClassLoader())) {
            if (!docLint.getName().equals("doclint")) continue;
            return docLint;
        }
        return (DocLint)provider.get();
    }

    private static class ProviderImpl<S>
    implements Provider<S> {
        final Class<S> service;
        final Class<? extends S> type;
        final Method factoryMethod;
        final Constructor<? extends S> ctor;
        final AccessControlContext acc;

        ProviderImpl(Class<S> service, Class<? extends S> type, Method factoryMethod, AccessControlContext acc) {
            this.service = service;
            this.type = type;
            this.factoryMethod = factoryMethod;
            this.ctor = null;
            this.acc = acc;
        }

        ProviderImpl(Class<S> service, Class<? extends S> type, Constructor<? extends S> ctor, AccessControlContext acc) {
            this.service = service;
            this.type = type;
            this.factoryMethod = null;
            this.ctor = ctor;
            this.acc = acc;
        }

        @Override
        public Class<? extends S> type() {
            return this.type;
        }

        @Override
        public S get() {
            if (this.factoryMethod != null) {
                return this.invokeFactoryMethod();
            }
            return this.newInstance();
        }

        private S invokeFactoryMethod() {
            Object result = null;
            Throwable exc = null;
            if (this.acc == null) {
                try {
                    result = this.factoryMethod.invoke(null, new Object[0]);
                }
                catch (Throwable x) {
                    exc = x;
                }
            } else {
                PrivilegedExceptionAction<Object> pa = () -> this.factoryMethod.invoke(null, new Object[0]);
                try {
                    result = AccessController.doPrivileged(pa, this.acc);
                }
                catch (Throwable x) {
                    if (x instanceof PrivilegedActionException) {
                        x = x.getCause();
                    }
                    exc = x;
                }
            }
            if (exc != null) {
                if (exc instanceof InvocationTargetException) {
                    exc = exc.getCause();
                }
                ProviderImpl.fail(this.service, this.factoryMethod + " failed", exc);
            }
            if (result == null) {
                ProviderImpl.fail(this.service, this.factoryMethod + " returned null");
            }
            Object p = result;
            return (S)p;
        }

        private S newInstance() {
            S p = null;
            Throwable exc = null;
            if (this.acc == null) {
                try {
                    p = this.ctor.newInstance(new Object[0]);
                }
                catch (Throwable x) {
                    exc = x;
                }
            } else {
                PrivilegedExceptionAction pa = new PrivilegedExceptionAction<S>(){

                    @Override
                    public S run() throws Exception {
                        return ctor.newInstance(new Object[0]);
                    }
                };
                try {
                    p = (S)AccessController.doPrivileged(pa, this.acc);
                }
                catch (Throwable x) {
                    if (x instanceof PrivilegedActionException) {
                        x = x.getCause();
                    }
                    exc = x;
                }
            }
            if (exc != null) {
                if (exc instanceof InvocationTargetException) {
                    exc = exc.getCause();
                }
                String cn = this.ctor.getDeclaringClass().getName();
                ProviderImpl.fail(this.service, "Provider " + cn + " could not be instantiated", exc);
            }
            return p;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.type, this.acc);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof ProviderImpl)) {
                return false;
            }
            ProviderImpl that = (ProviderImpl)ob;
            return this.service == that.service && this.type == that.type && Objects.equals(this.acc, that.acc);
        }

        private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
            throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
        }

        private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
            throw new ServiceConfigurationError(service.getName() + ": " + msg);
        }

        private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
            ProviderImpl.fail(service, u + ":" + line + ": " + msg);
        }
    }

    public static interface Provider<S>
    extends Supplier<S> {
        public Class<? extends S> type();

        @Override
        public S get();
    }

    private static class NoDocLint
    extends DocLint {
        private NoDocLint() {
        }

        @Override
        public String getName() {
            return "doclint-not-available";
        }

        @Override
        public void init(JavacTask task, String ... args) {
            throw new IllegalStateException("doclint not available");
        }

        @Override
        public boolean isValidOption(String s) {
            return s.equals(DocLint.XMSGS_OPTION) || s.startsWith(DocLint.XMSGS_CUSTOM_PREFIX) || s.startsWith(DocLint.XCHECK_PACKAGE);
        }
    }
}

