/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.api.ClassNamesForFileOraculum;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.file.JRTIndex;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.main.DelegatingJavaFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class ClassFinder {
    protected static final Context.Key<ClassFinder> classFinderKey = new Context.Key();
    ClassReader reader;
    private final Annotate annotate;
    boolean verbose;
    private boolean cacheCompletionFailure;
    protected boolean preferSource;
    protected boolean userPathsFirst;
    final Log log;
    Symtab syms;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    private final Dependencies dependencies;
    JCDiagnostic.Factory diagFactory;
    final DeferredCompletionFailureHandler dcfh;
    private final ClassNamesForFileOraculum classNamesOraculum;
    public Symbol.Completer sourceCompleter = Symbol.Completer.NULL_COMPLETER;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    private final Profile profile;
    private final JRTIndex jrtIndex;
    private final Symbol.Completer thisCompleter = this::complete;
    private Map<Symbol.PackageSymbol, Long> supplementaryFlags;
    public Runnable ap = null;
    private final Symbol.CompletionFailure cachedCompletionFailure;
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath = true;
    private boolean preferCurrent;

    public Symbol.Completer getCompleter() {
        return this.thisCompleter;
    }

    public static ClassFinder instance(Context context) {
        ClassFinder instance = context.get(classFinderKey);
        if (instance == null) {
            instance = new ClassFinder(context);
        }
        return instance;
    }

    protected ClassFinder(Context context) {
        JavacFileManager jfm;
        context.put(classFinderKey, this);
        this.reader = ClassReader.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dependencies = Dependencies.instance(context);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.classNamesOraculum = context.get(ClassNamesForFileOraculum.class);
        this.log = Log.instance(context);
        this.annotate = Annotate.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.userPathsFirst = options.isSet(Option.XXUSERPATHSFIRST);
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
        JavaFileManager fm = context.get(JavaFileManager.class);
        if (fm instanceof DelegatingJavaFileManager) {
            fm = ((DelegatingJavaFileManager)fm).getBaseFileManager();
        }
        boolean useCtProps = fm instanceof JavacFileManager ? (jfm = (JavacFileManager)fm).isDefaultBootClassPath() && jfm.isSymbolFileEnabled() : (fm.getClass().getName().equals("com.sun.tools.sjavac.comp.SmartFileManager") ? !options.isSet("ignore.symbol.file") : false);
        this.jrtIndex = useCtProps && JRTIndex.isAvailable() ? JRTIndex.getSharedInstance() : null;
        this.profile = Profile.instance(context);
        this.cachedCompletionFailure = new Symbol.CompletionFailure(null, () -> null, this.dcfh);
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
    }

    long getSupplementaryFlags(Symbol.ClassSymbol c) {
        Long flags;
        if (this.jrtIndex == null || !this.jrtIndex.isInJRT(c.classfile) || c.name == this.names.module_info) {
            return 0L;
        }
        if (this.supplementaryFlags == null) {
            this.supplementaryFlags = new HashMap<Symbol.PackageSymbol, Long>();
        }
        if ((flags = this.supplementaryFlags.get(c.packge())) == null) {
            long newFlags = 0L;
            try {
                JRTIndex.CtSym ctSym = this.jrtIndex.getCtSym(c.packge().flatName());
                Profile minProfile = Profile.DEFAULT;
                if (ctSym.proprietary) {
                    newFlags |= 0x4000000000L;
                }
                if (ctSym.minProfile != null) {
                    minProfile = Profile.lookup(ctSym.minProfile);
                }
                if (this.profile != Profile.DEFAULT && minProfile.value > this.profile.value) {
                    newFlags |= 0x200000000000L;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            flags = newFlags;
            this.supplementaryFlags.put(c.packge(), flags);
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void complete(Symbol sym) throws Symbol.CompletionFailure {
        try {
            if (sym.kind == Kinds.Kind.TYP) {
                try {
                    c = (Symbol.ClassSymbol)sym;
                    this.dependencies.push(c, Dependencies.CompletionCause.CLASS_READER);
                    this.annotate.blockAnnotations();
                    c.members_field = new Scope.ErrorScope(c);
                    tempScope = c.members_field;
                    this.completeOwners(c.owner);
                    this.completeEnclosing(c);
                    if (c.members_field != tempScope) ** GOTO lbl29
                    try {
                        this.fillIn(c);
                    }
                    catch (Abort a) {
                        this.syms.removeClass(c.packge().modle, c.flatname);
                    }
                }
                finally {
                    this.annotate.unblockAnnotationsNoFlush();
                    this.dependencies.pop();
                }
            } else if (sym.kind == Kinds.Kind.PCK) {
                p = (Symbol.PackageSymbol)sym;
                try {
                    this.fillIn(p);
                }
                catch (IOException ex) {
                    throw new Symbol.CompletionFailure(sym, (Supplier<JCDiagnostic>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$complete$1(java.io.IOException ), ()Lcom/sun/tools/javac/util/JCDiagnostic;)((ClassFinder)this, (IOException)ex), this.dcfh).initCause(ex);
                }
            }
lbl29:
            // 6 sources

            if (!this.reader.filling) {
                this.annotate.flush();
            }
        }
        finally {
            if (this.ap != null) {
                r = this.ap;
                this.ap = null;
                r.run();
            }
        }
    }

    private void completeOwners(Symbol o) {
        if (o.kind != Kinds.Kind.PCK) {
            this.completeOwners(o.owner);
        }
        o.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol c) {
        if (c.owner.kind == Kinds.Kind.PCK) {
            Symbol owner = c.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(c.name))) {
                Symbol encl = owner.members().findFirst(name);
                if (encl == null) {
                    encl = this.syms.getClass(c.packge().modle, Symbol.TypeSymbol.formFlatName(name, owner));
                }
                if (encl == null) continue;
                encl.complete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void fillIn(Symbol.ClassSymbol c) {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, () -> this.diagFactory.fragment(CompilerProperties.Fragments.UserSelectedCompletionFailure), this.dcfh);
        }
        this.currentOwner = c;
        JavaFileObject classfile = c.classfile;
        if (classfile == null) throw this.classFileNotFound(c);
        JavaFileObject previousClassFile = this.currentClassFile;
        Symbol prevOwner = c.owner;
        Name prevName = c.fullname;
        try {
            if (this.reader.filling) {
                Assert.error("Filling " + classfile.toUri() + " during " + previousClassFile);
            }
            this.currentClassFile = classfile;
            if (this.verbose) {
                this.log.printVerbose("loading", this.currentClassFile.getName());
            }
            if (classfile.getKind() == JavaFileObject.Kind.CLASS) {
                this.reader.readClassFile(c);
                c.flags_field |= this.getSupplementaryFlags(c);
                return;
            } else {
                if (this.sourceCompleter.isTerminal()) throw new IllegalStateException("Source completer required to read " + classfile.toUri());
                if (classfile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE)) return;
                this.sourceCompleter.complete(c);
                return;
            }
        }
        catch (BadClassFile cf) {
            c.owner = prevOwner;
            c.members_field.getSymbols(sym -> sym.kind == Kinds.Kind.TYP).forEach(sym -> {
                Symbol.ClassSymbol csym = (Symbol.ClassSymbol)sym;
                csym.owner = sym.packge();
                csym.owner.members().enter((Symbol)sym);
                csym.fullname = sym.flatName();
                csym.name = Convert.shortName(sym.flatName());
                csym.reset();
            });
            c.fullname = prevName;
            c.name = Convert.shortName(prevName);
            c.reset();
            throw cf;
        }
        finally {
            this.currentClassFile = previousClassFile;
        }
    }

    private Symbol.CompletionFailure classFileNotFound(Symbol.ClassSymbol c) {
        return this.newCompletionFailure(c, () -> this.diagFactory.fragment(CompilerProperties.Fragments.ClassFileNotFound(c.flatname)));
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol c, Supplier<JCDiagnostic> diag) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure(c, diag, this.dcfh);
        }
        Symbol.CompletionFailure result = this.cachedCompletionFailure;
        result.sym = c;
        result.resetDiagnostic(diag);
        return result;
    }

    public Symbol.ClassSymbol loadClass(Symbol.ModuleSymbol msym, Name flatname) throws Symbol.CompletionFailure {
        Assert.checkNonNull(msym);
        Name packageName = Convert.packagePart(flatname);
        Symbol.PackageSymbol ps = this.syms.lookupPackage(msym, packageName);
        Assert.checkNonNull(ps.modle, () -> "msym=" + msym + "; flatName=" + flatname);
        boolean absent = this.syms.getClass(ps.modle, flatname) == null;
        Symbol.ClassSymbol c = this.syms.enterClass(ps.modle, flatname);
        if (c.members_field == null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.syms.removeClass(ps.modle, flatname);
                    ex.dcfh.classSymbolRemoved(c);
                }
                throw ex;
            }
        }
        return c;
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file) {
        String binaryName = this.fileManager.inferBinaryName(this.currentLoc, file);
        this.includeClassFile(p, file, binaryName);
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file, String binaryName) {
        Symbol.ClassSymbol c;
        JavaFileObject.Kind kind;
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == Kinds.Kind.PCK) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        int seen = (kind = file.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        int lastDot = binaryName.lastIndexOf(".");
        Name classname = this.names.fromString(binaryName.substring(lastDot + 1));
        boolean isPkgInfo = classname == this.names.package_info;
        Symbol.ClassSymbol classSymbol = c = isPkgInfo ? p.package_info : (Symbol.ClassSymbol)p.members_field.findFirst(classname);
        if (c == null) {
            c = this.syms.enterClass(p.modle, classname, p);
            if (c.classfile == null) {
                c.classfile = file;
            }
            if (isPkgInfo) {
                p.package_info = c;
            } else if (c.owner == p) {
                p.members_field.enter(c);
            }
        } else if (!this.preferCurrent && c.classfile != null && (c.flags_field & (long)seen) == 0L) {
            if ((c.flags_field & 0x6000000L) != 0L) {
                c.classfile = this.preferredFileObject(file, c.classfile);
            }
        } else if (c.classfile != null && this.isSigOverClass(c.classfile, file)) {
            c.classfile = file;
        }
        c.flags_field |= (long)seen;
    }

    private boolean isSigOverClass(JavaFileObject a, JavaFileObject b) {
        String patha = a.getName().toLowerCase();
        String pathb = b.getName().toLowerCase();
        return pathb.endsWith(".sig") && patha.endsWith(".class");
    }

    protected JavaFileObject preferredFileObject(JavaFileObject a, JavaFileObject b) {
        long bdate;
        if (this.preferSource && !b.getName().toLowerCase().endsWith(".sig")) {
            return a.getKind() == JavaFileObject.Kind.SOURCE ? a : b;
        }
        long adate = a.getLastModified();
        return adate > (bdate = b.getLastModified()) ? a : b;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol pack, JavaFileObject fe) {
    }

    private void fillIn(Symbol.PackageSymbol p) throws IOException {
        if (p.members_field == null) {
            p.members_field = Scope.WriteableScope.create(p);
        }
        Symbol.ModuleSymbol msym = p.modle;
        Assert.checkNonNull(msym, p::toString);
        msym.complete();
        if (msym == this.syms.noModule) {
            this.preferCurrent = false;
            if (this.userPathsFirst) {
                this.scanUserPaths(p, true);
                this.preferCurrent = true;
                this.scanPlatformPath(p);
            } else {
                this.scanPlatformPath(p);
                this.scanUserPaths(p, true);
            }
        } else if (msym.classLocation == StandardLocation.CLASS_PATH) {
            this.scanUserPaths(p, msym.sourceLocation == StandardLocation.SOURCE_PATH);
        } else {
            this.scanModulePaths(p, msym);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanModulePaths(Symbol.PackageSymbol p, Symbol.ModuleSymbol msym) throws IOException {
        EnumSet<JavaFileObject.Kind> kinds = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> classKinds = EnumSet.copyOf(kinds);
        classKinds.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean wantClassFiles = !classKinds.isEmpty();
        EnumSet<JavaFileObject.Kind> sourceKinds = EnumSet.copyOf(kinds);
        sourceKinds.remove((Object)JavaFileObject.Kind.CLASS);
        boolean wantSourceFiles = !sourceKinds.isEmpty();
        String packageName = p.fullname.toString();
        JavaFileManager.Location classLocn = msym.classLocation;
        JavaFileManager.Location sourceLocn = msym.sourceLocation;
        JavaFileManager.Location patchLocn = msym.patchLocation;
        JavaFileManager.Location patchOutLocn = msym.patchOutputLocation;
        boolean prevPreferCurrent = this.preferCurrent;
        try {
            this.preferCurrent = false;
            if (wantClassFiles && patchOutLocn != null) {
                this.fillIn(p, patchOutLocn, this.list(patchOutLocn, p, packageName, classKinds));
            }
            if ((wantClassFiles || wantSourceFiles) && patchLocn != null) {
                EnumSet<JavaFileObject.Kind> combined = EnumSet.noneOf(JavaFileObject.Kind.class);
                combined.addAll(classKinds);
                combined.addAll(sourceKinds);
                this.fillIn(p, patchLocn, this.list(patchLocn, p, packageName, combined));
            }
            this.preferCurrent = true;
            if (wantClassFiles && classLocn != null) {
                this.fillIn(p, classLocn, this.list(classLocn, p, packageName, classKinds));
            }
            if (wantSourceFiles && sourceLocn != null) {
                this.fillIn(p, sourceLocn, this.list(sourceLocn, p, packageName, sourceKinds));
            }
        }
        finally {
            this.preferCurrent = prevPreferCurrent;
        }
    }

    private void scanUserPaths(Symbol.PackageSymbol p, boolean includeSourcePath) throws IOException {
        boolean haveSourcePath;
        EnumSet<JavaFileObject.Kind> kinds = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> classKinds = EnumSet.copyOf(kinds);
        classKinds.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean wantClassFiles = !classKinds.isEmpty();
        EnumSet<JavaFileObject.Kind> sourceKinds = EnumSet.copyOf(kinds);
        sourceKinds.remove((Object)JavaFileObject.Kind.CLASS);
        boolean wantSourceFiles = !sourceKinds.isEmpty();
        boolean bl = haveSourcePath = includeSourcePath && this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath) {
            this.verbosePath = false;
            if (this.fileManager instanceof StandardJavaFileManager) {
                List<Object> path;
                StandardJavaFileManager fm = (StandardJavaFileManager)this.fileManager;
                if (haveSourcePath && wantSourceFiles) {
                    path = List.nil();
                    for (Path path2 : fm.getLocationAsPaths(StandardLocation.SOURCE_PATH)) {
                        path = path.prepend(path2);
                    }
                    this.log.printVerbose("sourcepath", path.reverse().toString());
                } else if (wantSourceFiles) {
                    path = List.nil();
                    for (Path path3 : fm.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                        path = path.prepend(path3);
                    }
                    this.log.printVerbose("sourcepath", path.reverse().toString());
                }
                if (wantClassFiles) {
                    path = List.nil();
                    for (Path path4 : fm.getLocationAsPaths(StandardLocation.PLATFORM_CLASS_PATH)) {
                        path = path.prepend(path4);
                    }
                    for (Path path5 : fm.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                        path = path.prepend(path5);
                    }
                    this.log.printVerbose("classpath", path.reverse().toString());
                }
            }
        }
        String packageName = p.fullname.toString();
        if (wantSourceFiles && !haveSourcePath) {
            this.fillIn(p, StandardLocation.CLASS_PATH, this.list(StandardLocation.CLASS_PATH, p, packageName, kinds));
        } else {
            if (wantClassFiles) {
                this.fillIn(p, StandardLocation.CLASS_PATH, this.list(StandardLocation.CLASS_PATH, p, packageName, classKinds));
            }
            if (wantSourceFiles) {
                this.fillIn(p, StandardLocation.SOURCE_PATH, this.list(StandardLocation.SOURCE_PATH, p, packageName, sourceKinds));
            }
        }
    }

    private void scanPlatformPath(Symbol.PackageSymbol p) throws IOException {
        this.fillIn(p, StandardLocation.PLATFORM_CLASS_PATH, this.list(StandardLocation.PLATFORM_CLASS_PATH, p, p.fullname.toString(), EnumSet.of(JavaFileObject.Kind.CLASS)));
    }

    private void fillIn(Symbol.PackageSymbol p, JavaFileManager.Location location, Iterable<JavaFileObject> files) {
        JavaFileObject[] sources;
        this.currentLoc = location;
        block4: for (JavaFileObject fo : files) {
            switch (fo.getKind()) {
                case OTHER: {
                    this.extraFileActions(p, fo);
                    break;
                }
                case CLASS: 
                case SOURCE: {
                    String binaryName;
                    String[] binaryNames = null;
                    if (this.classNamesOraculum != null) {
                        binaryNames = this.classNamesOraculum.divineClassName(fo);
                    }
                    if (binaryNames == null && (binaryName = this.fileManager.inferBinaryName(this.currentLoc, fo)) != null) {
                        binaryNames = new String[]{binaryName};
                    }
                    if (binaryNames == null) continue block4;
                    for (String binaryName2 : binaryNames) {
                        String simpleName = binaryName2.substring(binaryName2.lastIndexOf(".") + 1);
                        if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue;
                        this.includeClassFile(p, fo);
                    }
                    continue block4;
                }
                default: {
                    this.extraFileActions(p, fo);
                }
            }
        }
        if (this.classNamesOraculum != null && location == StandardLocation.SOURCE_PATH && (sources = this.classNamesOraculum.divineSources(p.fullname.toString())) != null) {
            for (JavaFileObject fo : sources) {
                for (String binaryName : this.classNamesOraculum.divineClassName(fo)) {
                    String simpleName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue;
                    this.includeClassFile(p, fo, binaryName);
                }
            }
        }
    }

    Iterable<JavaFileObject> list(JavaFileManager.Location location, final Symbol.PackageSymbol p, String packageName, final Set<JavaFileObject.Kind> kinds) throws IOException {
        final Iterable<JavaFileObject> listed = this.fileManager.list(location, packageName, EnumSet.allOf(JavaFileObject.Kind.class), false);
        return () -> new Iterator<JavaFileObject>(){
            private JavaFileObject next;
            private final Iterator original;
            {
                this.original = listed.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.original.hasNext()) {
                        JavaFileObject fo = (JavaFileObject)this.original.next();
                        if (fo.getKind() != JavaFileObject.Kind.CLASS && fo.getKind() != JavaFileObject.Kind.SOURCE) {
                            p.flags_field |= 0x10000000000000L;
                        }
                        if (!kinds.contains((Object)fo.getKind())) continue;
                        this.next = fo;
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public JavaFileObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                JavaFileObject result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    private /* synthetic */ JCDiagnostic lambda$complete$1(IOException ex) {
        return this.diagFactory.fragment(CompilerProperties.Fragments.ExceptionMessage(ex.getLocalizedMessage()));
    }

    public static class BadEnclosingMethodAttr
    extends BadClassFile {
        private static final long serialVersionUID = 0L;

        public BadEnclosingMethodAttr(Symbol.TypeSymbol sym, JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory, DeferredCompletionFailureHandler dcfh) {
            super(sym, file, diag, diagFactory, dcfh);
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol sym, JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory, DeferredCompletionFailureHandler dcfh) {
            super(sym, () -> BadClassFile.createBadClassFileDiagnostic(file, diag, diagFactory), dcfh);
        }

        private static JCDiagnostic createBadClassFileDiagnostic(JavaFileObject file, JCDiagnostic diag, JCDiagnostic.Factory diagFactory) {
            String key = file.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
            return diagFactory.fragment(key, file, diag);
        }
    }
}

