/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.model.LazyTreeLoader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public class MemberEnter
extends JCTree.Visitor {
    protected static final Context.Key<MemberEnter> memberEnterKey = new Context.Key();
    private final Names names;
    private final Enter enter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final Annotate annotate;
    private final Types types;
    private final DeferredLintHandler deferredLintHandler;
    private final LazyTreeLoader treeLoader;
    protected Env<AttrContext> env;
    private static TreeScanner treeCleaner = new TreeScanner(){

        @Override
        public void scan(JCTree node) {
            super.scan(node);
            if (node != null) {
                node.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            node.packge = null;
            super.visitTopLevel(node);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl node) {
            node.sym = null;
            super.visitClassDef(node);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl node) {
            node.sym = null;
            super.visitMethodDef(node);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl node) {
            node.sym = null;
            super.visitVarDef(node);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass node) {
            node.constructor = null;
            super.visitNewClass(node);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp node) {
            node.operator = null;
            super.visitAssignop(node);
        }

        @Override
        public void visitUnary(JCTree.JCUnary node) {
            node.operator = null;
            super.visitUnary(node);
        }

        @Override
        public void visitBinary(JCTree.JCBinary node) {
            node.operator = null;
            super.visitBinary(node);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess node) {
            node.sym = null;
            super.visitSelect(node);
        }

        @Override
        public void visitIdent(JCTree.JCIdent node) {
            node.sym = null;
            super.visitIdent(node);
        }
    };

    public static MemberEnter instance(Context context) {
        MemberEnter instance = context.get(memberEnterKey);
        if (instance == null) {
            instance = new MemberEnter(context);
        }
        return instance;
    }

    protected MemberEnter(Context context) {
        context.put(memberEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.treeLoader = LazyTreeLoader.instance(context);
    }

    Type signature(Symbol.MethodSymbol msym, List<JCTree.JCTypeParameter> typarams, List<JCTree.JCVariableDecl> params, JCTree res, JCTree.JCVariableDecl recvparam, List<JCTree.JCExpression> thrown, Env<AttrContext> env) {
        Type recvtype;
        Type.JCVoidType restype;
        List<Type> tvars = this.enter.classEnter(typarams, env);
        this.attr.attribTypeVariables(typarams, env, true);
        ListBuffer<Type> argbuf = new ListBuffer<Type>();
        List<JCTree.JCVariableDecl> l = params;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            argbuf.append(((JCTree.JCVariableDecl)l.head).vartype.type);
            l = l.tail;
        }
        Type type = restype = res == null ? this.syms.voidType : this.attr.attribType(res, env);
        if (recvparam != null) {
            this.memberEnter(recvparam, env);
            recvtype = recvparam.vartype.type;
        } else {
            recvtype = null;
        }
        ListBuffer<Type> thrownbuf = new ListBuffer<Type>();
        List<JCTree.JCExpression> l2 = thrown;
        while (l2.nonEmpty()) {
            Type exc = this.attr.attribType((JCTree)l2.head, env);
            if (!exc.hasTag(TypeTag.TYPEVAR)) {
                exc = this.chk.checkClassType(((JCTree.JCExpression)l2.head).pos(), exc);
            } else if (exc.tsym.owner == msym) {
                exc.tsym.flags_field |= 0x800000000000L;
            }
            thrownbuf.append(exc);
            l2 = l2.tail;
        }
        Type.MethodType mtype = new Type.MethodType(argbuf.toList(), restype, thrownbuf.toList(), this.syms.methodClass);
        mtype.recvtype = recvtype;
        return tvars.isEmpty() ? mtype : new Type.ForAll(tvars, (Type)mtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(JCTree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    void memberEnter(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            l = l.tail;
        }
    }

    boolean hasSameBounds(Type.ForAll t, Type.ForAll s) {
        List<Type> l1 = t.tvars;
        List<Type> l2 = s.tvars;
        while (l1.nonEmpty() && l2.nonEmpty() && this.isSameAPType(((Type)l1.head).getUpperBound(), this.types.subst(((Type)l2.head).getUpperBound(), s.tvars, t.tvars))) {
            l1 = l1.tail;
            l2 = l2.tail;
        }
        return l1.isEmpty() && l2.isEmpty();
    }

    private boolean isSameAPType(Type t, Type s) {
        return t != null && !t.hasTag(TypeTag.UNKNOWN) && this.types.isSameType(t, s) || t.tsym != null && s.tsym != null && s.isErroneous() && t.tsym.name == s.tsym.name;
    }

    private boolean isSameMethod(Type ot, Type os) {
        if (ot.getTag() != os.getTag()) {
            return false;
        }
        switch (ot.getTag()) {
            case METHOD: {
                Type.MethodType t = (Type.MethodType)ot;
                Type.MethodType s = (Type.MethodType)os;
                if (((List)t.getParameterTypes()).size() != ((List)s.getParameterTypes()).size()) {
                    return false;
                }
                if (!this.isSameAPType(t.getReturnType(), s.getReturnType())) {
                    return false;
                }
                List tp = t.getParameterTypes();
                List sp = s.getParameterTypes();
                while (!tp.isEmpty() && !sp.isEmpty()) {
                    if (!this.isSameAPType((Type)tp.head, (Type)sp.head)) {
                        return false;
                    }
                    tp = tp.tail;
                    sp = sp.tail;
                }
                return tp.isEmpty() == sp.isEmpty();
            }
            case FORALL: {
                Type.ForAll t = (Type.ForAll)ot;
                Type.ForAll s = (Type.ForAll)os;
                return this.hasSameBounds(t, s) && this.isSameMethod(t.qtype, this.types.subst(s.qtype, s.tvars, t.tvars));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(0L, tree.name, null, enclScope.owner);
        m.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, m, tree);
        tree.sym = m;
        if ((tree.mods.flags & 0x80000000000L) != 0L) {
            m.owner.flags_field |= 0x80000000000L;
        }
        Env<AttrContext> localEnv = this.methodEnv(tree, this.env);
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        try {
            m.type = this.signature(m, tree.typarams, tree.params, tree.restype, tree.recvparam, tree.thrown, localEnv);
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
        }
        if (this.types.isSignaturePolymorphic(m)) {
            m.flags_field |= 0x400000000000L;
        }
        if ((enclScope.owner.flags_field & 0x80000L) != 0L) {
            for (Symbol sym : enclScope.getSymbolsByName(tree.name)) {
                List<Symbol.VarSymbol> p;
                boolean sameType;
                if (sym.kind != Kinds.Kind.MTH || !(sameType = (enclScope.owner.flags_field & 0x200000L) != 0L ? this.isSameMethod(m.type, sym.type) : this.types.isSameType(m.type, sym.type))) continue;
                if ((sym.flags_field & 0x80000L) == 0L) break;
                treeCleaner.scan(tree);
                tree.sym = (Symbol.MethodSymbol)sym;
                localEnv = this.methodEnv(tree, this.env);
                tree.sym.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, tree.sym, tree) | tree.sym.flags_field & 0x200000L;
                tree.sym.flags_field |= 0x80000L;
                if (tree.sym.type.hasTag(TypeTag.FORALL)) {
                    List<Type> tvars = ((Type.ForAll)tree.sym.type).tvars;
                    while (tvars.nonEmpty()) {
                        ((AttrContext)localEnv.info).scope.enter(((Type)tvars.head).tsym);
                        tvars = tvars.tail;
                    }
                }
                if ((p = tree.sym.params().reverse()) != null) {
                    List<JCTree.JCVariableDecl> l = tree.params.reverse();
                    while (l.nonEmpty() && p.nonEmpty()) {
                        ((Symbol.VarSymbol)p.head).setName(((JCTree.JCVariableDecl)l.head).name);
                        if (((JCTree.JCVariableDecl)l.head).getModifiers() != null && ((JCTree.JCVariableDecl)l.head).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                            ((Symbol.VarSymbol)p.head).flags_field |= 0x10L;
                        }
                        ((AttrContext)localEnv.info).scope.enter((Symbol)p.head);
                        ((Symbol.VarSymbol)p.head).flags_field |= 0x80000L;
                        p = p.tail;
                        l = l.tail;
                    }
                    while (p.nonEmpty()) {
                        ((Symbol.VarSymbol)p.head).setName(((Symbol.VarSymbol)p.head).name);
                        ((AttrContext)localEnv.info).scope.enter((Symbol)p.head);
                        p = p.tail;
                    }
                }
                prevLintPos = this.deferredLintHandler.setPos(tree.pos());
                try {
                    tree.sym.type = this.signature(tree.sym, tree.typarams, tree.params, tree.restype, tree.recvparam, tree.thrown, localEnv);
                }
                finally {
                    this.deferredLintHandler.setPos(prevLintPos);
                }
                tree.sym.flags_field &= 0xFFFFFFFFFFF7FFFFL;
                ((AttrContext)localEnv.info).scope.leave();
                ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
                JCTree.JCVariableDecl lastParam = null;
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl param = lastParam = (JCTree.JCVariableDecl)l.head;
                    params.append(Assert.checkNonNull(param.sym));
                    l = l.tail;
                }
                tree.sym.params = params.toList();
                if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
                    tree.sym.flags_field |= 0x400000000L;
                }
                tree.sym.flags_field &= 0xFFFFFFFFFFDFFFFFL;
                break;
            }
            if (tree.sym == m) {
                if (!((enclScope.owner.flags_field & 0x200000L) != 0L || m.name == this.names.init && m.owner.owner.kind.matches(Kinds.KindSelector.VAL_MTH))) {
                    Symbol.ClassSymbol cs = enclScope.owner.outermostClass();
                    this.treeLoader.couplingError(cs, tree);
                } else {
                    ((AttrContext)localEnv.info).scope.leave();
                    ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
                    JCTree.JCVariableDecl lastParam = null;
                    List<JCTree.JCVariableDecl> l = tree.params;
                    while (l.nonEmpty()) {
                        JCTree.JCVariableDecl param = lastParam = (JCTree.JCVariableDecl)l.head;
                        params.append(Assert.checkNonNull(param.sym));
                        l = l.tail;
                    }
                    m.params = params.toList();
                    if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
                        m.flags_field |= 0x400000000L;
                    }
                    if (this.chk.checkUnique(tree.pos(), m, enclScope)) {
                        enclScope.enter(m);
                    }
                }
            }
        } else {
            ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
            JCTree.JCVariableDecl lastParam = null;
            List<JCTree.JCVariableDecl> l = tree.params;
            while (l.nonEmpty()) {
                JCTree.JCVariableDecl param = lastParam = (JCTree.JCVariableDecl)l.head;
                params.append(Assert.checkNonNull(param.sym));
                l = l.tail;
            }
            m.params = params.toList();
            if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
                m.flags_field |= 0x400000000L;
            }
            ((AttrContext)localEnv.info).scope.leave();
            if (this.chk.checkUnique(tree.pos(), m, enclScope)) {
                enclScope.enter(m);
            }
        }
        this.annotate.annotateLater(tree.mods.annotations, localEnv, tree.sym, tree.pos());
        this.annotate.queueScanTreeAndTypeAnnotate(tree, localEnv, tree.sym, tree.pos());
        if (tree.defaultValue != null) {
            tree.sym.defaultValue = this.annotate.unfinishedDefaultValue();
            this.annotate.annotateDefaultValueLater(tree.defaultValue, localEnv, tree.sym, tree.pos());
        }
    }

    Env<AttrContext> methodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(tree.sym)));
        localEnv.enclMethod = tree;
        if (tree.sym.type != null) {
            AttrContext attrContext = (AttrContext)localEnv.info;
            Attr attr = this.attr;
            attr.getClass();
            attrContext.returnResult = attr.new Attr.ResultInfo(Kinds.KindSelector.VAL, tree.sym.type.getReturnType());
        }
        if ((tree.mods.flags & 8L) != 0L) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        ((AttrContext)localEnv.info).yieldResult = null;
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Env<AttrContext> localEnv = this.env;
        if ((tree.mods.flags & 8L) != 0L || (((AttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup());
            ++((AttrContext)localEnv.info).staticLevel;
        }
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        try {
            if (TreeInfo.isEnumInit(tree)) {
                this.attr.attribIdentAsEnumType(localEnv, (JCTree.JCIdent)tree.vartype);
            } else if (!tree.isImplicitlyTyped()) {
                this.attr.attribType((JCTree)tree.vartype, localEnv);
                if (TreeInfo.isReceiverParam(tree)) {
                    this.checkReceiver(tree, localEnv);
                }
            }
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
        }
        if (tree.vartype != null && tree.vartype.type != null && tree.vartype.type.hasTag(TypeTag.VOID)) {
            this.log.error(tree.vartype, CompilerProperties.Errors.IllegalStartOfType);
            tree.vartype.type = this.syms.errType;
        }
        if ((tree.mods.flags & 0x400000000L) != 0L) {
            Type.ArrayType atype = (Type.ArrayType)tree.vartype.type;
            tree.vartype.type = atype.makeVarargs();
        }
        Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
        Type vartype = tree.isImplicitlyTyped() ? (((AttrContext)this.env.info).scope.owner.kind == Kinds.Kind.MTH ? Type.noType : this.syms.errType) : tree.vartype.type;
        Symbol.VarSymbol v = null;
        boolean doEnterSymbol = true;
        if ((enclScope.owner.flags_field & 0x80000L) != 0L) {
            for (Symbol sym : enclScope.getSymbolsByName(tree.name)) {
                boolean sameType;
                boolean bl = sameType = (enclScope.owner.flags_field & 0x200000L) != 0L ? this.isSameAPType(vartype, sym.type) : this.types.isSameType(vartype, sym.type);
                if (sym.kind != Kinds.Kind.VAR || !sameType) continue;
                if ((sym.flags_field & 0x80000L) == 0L) break;
                v = (Symbol.VarSymbol)sym;
                v.type = vartype;
                sym.flags_field &= 0xFFFFFFFFFFF7FFFFL;
                break;
            }
            if (v != null) {
                doEnterSymbol = false;
            } else if ((enclScope.owner.flags_field & 0x200000L) == 0L) {
                Symbol.ClassSymbol cs = enclScope.owner.outermostClass();
                this.treeLoader.couplingError(cs, tree);
                doEnterSymbol = false;
            }
        }
        if (v == null) {
            v = new Symbol.VarSymbol(0L, tree.name, vartype, enclScope.owner);
        }
        v.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, v, tree);
        tree.sym = v;
        if (tree.init != null) {
            v.flags_field |= 0x40000L;
            if ((v.flags_field & 0x10L) != 0L && this.needsLazyConstValue(tree.init)) {
                Env<AttrContext> initEnv = this.getInitEnv(tree, this.env);
                ((AttrContext)initEnv.info).enclVar = v;
                v.setLazyConstValue(this.initEnv(tree, initEnv), this.attr, tree);
            }
        }
        if (doEnterSymbol) {
            if (this.chk.checkUnique(tree.pos(), v, enclScope)) {
                this.chk.checkTransparentVar(tree.pos(), v, enclScope);
                enclScope.enter(v);
            } else if (v.getKind() == ElementKind.LOCAL_VARIABLE) {
                enclScope.enter(v);
            } else if (v.owner.kind == Kinds.Kind.MTH || (v.flags_field & 0x2000000001000012L) != 0L) {
                enclScope.enter(v);
            }
        }
        this.annotate.annotateLater(tree.mods.annotations, localEnv, v, tree.pos());
        if (!tree.isImplicitlyTyped()) {
            this.annotate.queueScanTreeAndTypeAnnotate(tree.vartype, localEnv, v, tree.pos());
        }
        v.pos = tree.pos;
    }

    void checkType(JCTree tree, Type type, JCDiagnostic.Error errorKey) {
        if (!tree.type.isErroneous() && !this.types.isSameType(tree.type, type)) {
            this.log.error(tree, errorKey);
        }
    }

    void checkReceiver(JCTree.JCVariableDecl tree, Env<AttrContext> localEnv) {
        this.attr.attribExpr(tree.nameexpr, localEnv);
        Symbol.MethodSymbol m = localEnv.enclMethod.sym;
        if (m.isConstructor()) {
            Type outertype = m.owner.owner.type;
            if (outertype.hasTag(TypeTag.METHOD)) {
                outertype = m.owner.owner.owner.type;
            }
            if (outertype.hasTag(TypeTag.CLASS)) {
                this.checkType(tree.vartype, outertype, CompilerProperties.Errors.IncorrectConstructorReceiverType(outertype, tree.vartype.type));
                this.checkType(tree.nameexpr, outertype, CompilerProperties.Errors.IncorrectConstructorReceiverName(outertype, tree.nameexpr.type));
            } else {
                this.log.error(tree, CompilerProperties.Errors.ReceiverParameterNotApplicableConstructorToplevelClass);
            }
        } else {
            this.checkType(tree.vartype, m.owner.type, CompilerProperties.Errors.IncorrectReceiverType(m.owner.type, tree.vartype.type));
            this.checkType(tree.nameexpr, m.owner.type, CompilerProperties.Errors.IncorrectReceiverName(m.owner.type, tree.nameexpr.type));
        }
    }

    public boolean needsLazyConstValue(JCTree tree) {
        InitTreeVisitor initTreeVisitor = new InitTreeVisitor();
        tree.accept(initTreeVisitor);
        return initTreeVisitor.result;
    }

    Env<AttrContext> initEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dupto(new AttrContextEnv((JCTree)tree, ((AttrContext)env.info).dup()));
        if (tree.sym.owner.kind == Kinds.Kind.TYP || tree.sym.owner.kind == Kinds.Kind.ERR) {
            ((AttrContext)localEnv.info).scope = ((AttrContext)env.info).scope.dupUnshared(tree.sym);
        }
        if ((tree.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L && env.enclMethod == null) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    @Override
    public void visitTree(JCTree tree) {
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        if (tree.errs != null) {
            this.memberEnter(tree.errs, this.env);
        }
    }

    public Env<AttrContext> getMethodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        if (tree.sym == null) {
            return null;
        }
        Env<AttrContext> mEnv = this.methodEnv(tree, env);
        ((AttrContext)mEnv.info).lint = ((AttrContext)mEnv.info).lint.augment(tree.sym);
        List<JCTree> l = tree.typarams;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCTypeParameter)l.head).type.tsym);
            l = l.tail;
        }
        l = tree.params;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCVariableDecl)l.head).sym);
            l = l.tail;
        }
        return mEnv;
    }

    public Env<AttrContext> getInitEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        if (tree.sym == null) {
            return null;
        }
        Env<AttrContext> iEnv = this.initEnv(tree, env);
        return iEnv;
    }

    static class InitTreeVisitor
    extends JCTree.Visitor {
        private static final Set<JCTree.Tag> ALLOWED_OPERATORS = EnumSet.of(JCTree.Tag.POS, new JCTree.Tag[]{JCTree.Tag.NEG, JCTree.Tag.NOT, JCTree.Tag.COMPL, JCTree.Tag.PLUS, JCTree.Tag.MINUS, JCTree.Tag.MUL, JCTree.Tag.DIV, JCTree.Tag.MOD, JCTree.Tag.SL, JCTree.Tag.SR, JCTree.Tag.USR, JCTree.Tag.LT, JCTree.Tag.LE, JCTree.Tag.GT, JCTree.Tag.GE, JCTree.Tag.EQ, JCTree.Tag.NE, JCTree.Tag.BITAND, JCTree.Tag.BITXOR, JCTree.Tag.BITOR, JCTree.Tag.AND, JCTree.Tag.OR});
        boolean result = true;

        InitTreeVisitor() {
        }

        @Override
        public void visitTree(JCTree tree) {
            this.result = false;
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral that) {
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary that) {
            if (!ALLOWED_OPERATORS.contains((Object)that.getTag())) {
                this.result = false;
                return;
            }
            that.arg.accept(this);
        }

        @Override
        public void visitBinary(JCTree.JCBinary that) {
            if (!ALLOWED_OPERATORS.contains((Object)that.getTag())) {
                this.result = false;
                return;
            }
            that.lhs.accept(this);
            that.rhs.accept(this);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            tree.cond.accept(this);
            tree.truepart.accept(this);
            tree.falsepart.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitIdent(JCTree.JCIdent that) {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            tree.selected.accept(this);
        }
    }
}

