/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

class TextBlockSupport {
    private static final Method stripIndent = TextBlockSupport.getStringMethodOrNull("stripIndent");
    private static final Method translateEscapes = TextBlockSupport.getStringMethodOrNull("translateEscapes");
    private static final Method isBlank = TextBlockSupport.getStringMethodOrNull("isBlank");
    private static final Method stripLeading = TextBlockSupport.getStringMethodOrNull("stripLeading");

    TextBlockSupport() {
    }

    private static Method getStringMethodOrNull(String name) {
        try {
            return JavaTokenizer.StringShim.class.getMethod(name, String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Set<WhitespaceChecks> checkWhitespace(String string) {
        String lastLine;
        HashSet<WhitespaceChecks> checks = new HashSet<WhitespaceChecks>();
        if (string.isEmpty()) {
            return checks;
        }
        int outdent = 0;
        char lastChar = string.charAt(string.length() - 1);
        boolean optOut = lastChar == '\n' || lastChar == '\r';
        String[] lines = string.split("\\R");
        int length = lines.length;
        String string2 = lastLine = length == 0 ? "" : lines[length - 1];
        if (!optOut) {
            outdent = TextBlockSupport.indexOfNonWhitespace(lastLine);
            for (String line : lines) {
                if (!TextBlockSupport.isBlank(line) && (outdent = Integer.min(outdent, TextBlockSupport.indexOfNonWhitespace(line))) == 0) break;
            }
        }
        String start = lastLine.substring(0, outdent);
        for (String line : lines) {
            if (!TextBlockSupport.isBlank(line) && !line.startsWith(start)) {
                checks.add(WhitespaceChecks.INCONSISTENT);
            }
            if (outdent >= line.length() || !Character.isWhitespace(lastChar = line.charAt(line.length() - 1))) continue;
            checks.add(WhitespaceChecks.TRAILING);
        }
        return checks;
    }

    private static int indexOfNonWhitespace(String string) {
        return string.length() - TextBlockSupport.stripLeading(string).length();
    }

    static String stripIndent(String string) {
        try {
            string = (String)stripIndent.invoke(null, string);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return string;
    }

    static String translateEscapes(String string) {
        try {
            string = (String)translateEscapes.invoke(null, string);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return string;
    }

    static boolean isBlank(String string) {
        boolean isBlankStr;
        try {
            isBlankStr = (Boolean)isBlank.invoke(null, string);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return isBlankStr;
    }

    static String stripLeading(String string) {
        try {
            string = (String)isBlank.invoke(null, string);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return string;
    }

    static enum WhitespaceChecks {
        INCONSISTENT,
        TRAILING;

    }
}

