/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class DynatraceMetadataEnricher {
    private static final Logger logger = Logger.getLogger(DynatraceMetadataEnricher.class.getName());
    private static final String INDIRECTION_FILE_NAME = "dt_metadata_e617c525669e072eebe3d0f08212e8f2.properties";
    private static final String ALTERNATIVE_METADATA_FILENAME = "/var/lib/dynatrace/enrichment/dt_metadata.properties";

    DynatraceMetadataEnricher() {
    }

    static List<Dimension> getDynatraceMetadata() {
        return DynatraceMetadataEnricher.createDimensionList(DynatraceMetadataEnricher.getPropertiesWithIndirection(INDIRECTION_FILE_NAME, ALTERNATIVE_METADATA_FILENAME));
    }

    static List<Dimension> createDimensionList(Properties properties) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.isEmpty() || value.isEmpty()) {
                logger.log(Level.WARNING, () -> String.format("dropped properties '%s=%s' due to empty key and/or value", key, value));
                continue;
            }
            dimensions.add(Dimension.create(key, value));
        }
        return dimensions;
    }

    static String getMetadataFileName(Reader fileContents) throws IOException {
        if (fileContents == null) {
            throw new IOException("passed Reader cannot be null.");
        }
        String metadataFileName = null;
        try (BufferedReader reader = new BufferedReader(fileContents);){
            String line = reader.readLine();
            if (line != null && !line.isEmpty()) {
                metadataFileName = line;
            }
        }
        return metadataFileName;
    }

    static boolean fileExistsAndIsReadable(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists() && Files.isReadable(file.toPath())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static Properties getPropertiesWithIndirection(String indirectionFileName, String alternativeMetadataFilename) {
        Throwable throwable;
        String metadataFileName = null;
        Properties props = new Properties();
        try {
            throwable = null;
            try (FileReader indirectionFileReader = new FileReader(indirectionFileName);){
                metadataFileName = DynatraceMetadataEnricher.getMetadataFileName(indirectionFileReader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            logger.info("Indirection file not found. This is normal if OneAgent is not installed.");
        }
        catch (Exception e) {
            logger.info(String.format("Error while trying to read contents of OneAgent indirection file: %s", e));
        }
        if (metadataFileName == null || metadataFileName.isEmpty()) {
            if (DynatraceMetadataEnricher.fileExistsAndIsReadable(alternativeMetadataFilename)) {
                logger.log(Level.INFO, () -> String.format("Alternative metadata file exists, attempting to read from %s.", alternativeMetadataFilename));
                metadataFileName = alternativeMetadataFilename;
            } else {
                return props;
            }
        }
        try {
            throwable = null;
            try (FileReader reader = new FileReader(metadataFileName);){
                props.load(reader);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (FileNotFoundException e) {
            logger.warning("Failed to read properties file: File not found");
        }
        catch (Exception e) {
            logger.info(String.format("Error while trying to read contents of Dynatrace metadata file: %s", e));
        }
        return props;
    }
}

