/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.otp;

import com.eatthepath.otp.HmacOneTimePasswordGenerator;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeBasedOneTimePasswordGenerator
extends HmacOneTimePasswordGenerator {
    private final long timeStepMillis;
    public static final String TOTP_ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    public static final String TOTP_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static final String TOTP_ALGORITHM_HMAC_SHA512 = "HmacSHA512";

    public TimeBasedOneTimePasswordGenerator() throws NoSuchAlgorithmException {
        this(30L, TimeUnit.SECONDS);
    }

    public TimeBasedOneTimePasswordGenerator(long timeStep, TimeUnit timeStepUnit) throws NoSuchAlgorithmException {
        this(timeStep, timeStepUnit, 6);
    }

    public TimeBasedOneTimePasswordGenerator(long timeStep, TimeUnit timeStepUnit, int passwordLength) throws NoSuchAlgorithmException {
        this(timeStep, timeStepUnit, passwordLength, TOTP_ALGORITHM_HMAC_SHA1);
    }

    public TimeBasedOneTimePasswordGenerator(long timeStep, TimeUnit timeStepUnit, int passwordLength, String algorithm) throws NoSuchAlgorithmException {
        super(passwordLength, algorithm);
        this.timeStepMillis = timeStepUnit.toMillis(timeStep);
    }

    public int generateOneTimePassword(Key key, Date timestamp) throws InvalidKeyException {
        return this.generateOneTimePassword(key, timestamp.getTime() / this.timeStepMillis);
    }

    public long getTimeStep(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeStepMillis, TimeUnit.MILLISECONDS);
    }
}

