/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.maleorang;

import com.ecwid.maleorang.MailchimpMethod;
import com.ecwid.maleorang.MailchimpMethodInfo;
import com.ecwid.maleorang.MailchimpMethodInfo$WhenMappings;
import com.ecwid.maleorang.MailchimpObject;
import com.ecwid.maleorang.annotation.APIVersion;
import com.ecwid.maleorang.annotation.HttpMethod;
import com.ecwid.maleorang.annotation.Method;
import com.ecwid.maleorang.annotation.PathParam;
import com.ecwid.maleorang.annotation.QueryStringParam;
import com.ecwid.maleorang.util.ClassUtil;
import com.ecwid.maleorang.util.DateUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\rJ\b\u0010\u001a\u001a\u00020\rH\u0002J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/ecwid/maleorang/MailchimpMethodInfo;", "", "method", "Lcom/ecwid/maleorang/MailchimpMethod;", "(Lcom/ecwid/maleorang/MailchimpMethod;)V", "httpMethod", "Lcom/ecwid/maleorang/annotation/HttpMethod;", "getHttpMethod", "()Lcom/ecwid/maleorang/annotation/HttpMethod;", "methodAnnotation", "Lcom/ecwid/maleorang/annotation/Method;", "pathParams", "", "", "getPathParams", "()Ljava/util/Map;", "queryStringParams", "getQueryStringParams", "requestBody", "getRequestBody", "()Ljava/lang/String;", "version", "Lcom/ecwid/maleorang/annotation/APIVersion;", "getVersion", "()Lcom/ecwid/maleorang/annotation/APIVersion;", "buildPath", "buildQueryString", "buildUrl", "apiKey", "Companion", "maleorang-compileKotlin"})
public final class MailchimpMethodInfo {
    private final Method methodAnnotation;
    @NotNull
    private final APIVersion version;
    @NotNull
    private final HttpMethod httpMethod;
    @NotNull
    private final Map<String, String> pathParams;
    @NotNull
    private final Map<String, String> queryStringParams;
    @Nullable
    private final String requestBody;
    private final MailchimpMethod<?> method;
    private static final Pattern PATH_PLACEHOLDER_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final APIVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @NotNull
    public final Map<String, String> getPathParams() {
        return this.pathParams;
    }

    @NotNull
    public final Map<String, String> getQueryStringParams() {
        return this.queryStringParams;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    @NotNull
    public final String buildUrl(@NotNull String apiKey) {
        String string;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        int n2 = StringsKt.lastIndexOf$default((CharSequence)apiKey, (char)'-', (int)0, (boolean)false, (int)6, null);
        int dash = n2;
        if (dash > 0) {
            String string2 = apiKey;
            n = dash + 1;
            string = string2;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Wrong api key: " + apiKey);
        }
        String string3 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String prefix = string3;
        return "https://" + prefix + ".api.mailchimp.com/" + (Object)((Object)this.version) + this.buildPath() + this.buildQueryString();
    }

    @NotNull
    public final String buildPath() {
        StringBuffer result = new StringBuffer();
        Matcher matcher = MailchimpMethodInfo.Companion.getPATH_PLACEHOLDER_PATTERN().matcher(this.methodAnnotation.path());
        while (matcher.find()) {
            String value;
            String name = matcher.group(1);
            if (this.pathParams.get(name) == null) {
                throw (Throwable)new IllegalArgumentException("Missing path parameter: " + name);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(result);
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    private final String buildQueryString() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> map = this.queryStringParams;
        Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            String key = entry2.getKey();
            Map.Entry<String, String> entry3 = entry;
            String value = entry3.getValue();
            if (value == null) continue;
            sb.append(sb.length() == 0 ? (char)'?' : '&');
            sb.append(URLEncoder.encode(key, "UTF-8"));
            sb.append('=');
            sb.append(URLEncoder.encode(value, "UTF-8"));
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public MailchimpMethodInfo(@NotNull MailchimpMethod<?> method) {
        String string;
        Method a;
        MailchimpMethodInfo mailchimpMethodInfo;
        Class<?> clazz;
        block6: {
            Class<?> it;
            Intrinsics.checkParameterIsNotNull(method, (String)"method");
            this.method = method;
            clazz = this.method.getClass();
            mailchimpMethodInfo = this;
            for (Class<?> c = it = clazz; c != null; c = c.getSuperclass()) {
                a = c.getAnnotation(Method.class);
                if (a == null) {
                    continue;
                }
                break block6;
            }
            throw (Throwable)new IllegalArgumentException("Neither " + this.method.getClass() + " nor its superclasses are annotated with " + Method.class);
        }
        Object object = a;
        Method method2 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method.javaClass.let {\n \u2026thod::class.java}\")\n    }");
        mailchimpMethodInfo.methodAnnotation = method2;
        this.version = this.methodAnnotation.version();
        this.httpMethod = this.methodAnnotation.httpMethod();
        this.pathParams = MailchimpMethodInfo.Companion.getParams(this.method, PathParam.class, pathParams.1.INSTANCE);
        this.queryStringParams = MailchimpMethodInfo.Companion.getParams(this.method, QueryStringParam.class, queryStringParams.1.INSTANCE);
        MailchimpMethodInfo mailchimpMethodInfo2 = this;
        switch (MailchimpMethodInfo$WhenMappings.$EnumSwitchMapping$0[this.httpMethod.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                string = this.method.toJson();
                break;
            }
            default: {
                clazz = null;
                mailchimpMethodInfo = mailchimpMethodInfo2;
                Void $receiver = (Void)((Object)clazz);
                boolean bl = this.method.mapping.isEmpty();
                if (!bl) {
                    String string2 = (Object)((Object)this.httpMethod) + " method is not supposed to have request body: " + this.method;
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                object = clazz;
                mailchimpMethodInfo2 = mailchimpMethodInfo;
                string = (String)object;
            }
        }
        mailchimpMethodInfo2.requestBody = string;
    }

    static {
        Companion = new Companion(null);
        PATH_PLACEHOLDER_PATTERN = Pattern.compile("\\{(\\w+)\\}");
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\"\b\b\u0000\u0010\u000b*\u00020\f*\u0006\u0012\u0002\b\u00030\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u0011H\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/ecwid/maleorang/MailchimpMethodInfo$Companion;", "", "()V", "PATH_PLACEHOLDER_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPATH_PLACEHOLDER_PATTERN", "()Ljava/util/regex/Pattern;", "getParams", "", "", "A", "", "Lcom/ecwid/maleorang/MailchimpMethod;", "annotationClass", "Ljava/lang/Class;", "nameProvider", "Lkotlin/Function1;", "maleorang-compileKotlin"})
    private static final class Companion {
        private final Pattern getPATH_PLACEHOLDER_PATTERN() {
            return PATH_PLACEHOLDER_PATTERN;
        }

        private final <A extends Annotation> Map<String, String> getParams(@NotNull MailchimpMethod<?> $receiver, Class<A> annotationClass, Function1<? super A, String> nameProvider) {
            TreeMap treeMap = new TreeMap();
            TreeMap $receiver2 = treeMap;
            for (Field field : ClassUtil.INSTANCE.getAnnotatedFields($receiver.getClass(), annotationClass)) {
                String string;
                A annotation;
                if (field.getAnnotation(annotationClass) == null) {
                    Intrinsics.throwNpe();
                }
                Object object = nameProvider.invoke(annotation);
                String it = (String)object;
                Object object2 = it;
                String name = object2.length() > 0 ? it : field.getName();
                object = name;
                it = "\\w+";
                it = new Regex(it);
                boolean bl = it.matches((CharSequence)object);
                if (!bl) {
                    object2 = "Invalid param name: " + name;
                    throw (Throwable)new IllegalArgumentException(object2.toString());
                }
                bl = !$receiver2.containsKey(name);
                if (!bl) {
                    object2 = "Duplicate param name: " + name;
                    throw (Throwable)new IllegalArgumentException(object2.toString());
                }
                object = field.get($receiver);
                Object value = object;
                object2 = $receiver2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                Object object3 = value;
                object3 = Intrinsics.areEqual((Object)object3, null) ? (String)null : (object3 instanceof MailchimpObject ? ((MailchimpObject)value).toJson() : (object3 instanceof Date ? DateUtil.INSTANCE.formatDate((Date)value) : value.toString()));
                object2.put(string, object3);
            }
            Map<String, String> map = Collections.unmodifiableMap(treeMap);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.unmodifiable\u2026         }\n            })");
            return map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

