/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.DTO.scim.user;

import com.edmunds.rest.databricks.DTO.scim.group.GroupDTO;
import com.edmunds.rest.databricks.DTO.scim.user.EmailDTO;
import com.edmunds.rest.databricks.DTO.scim.user.EntitlementsDTO;
import com.edmunds.rest.databricks.DTO.scim.user.NameDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class UserDTO {
    @JsonProperty(value="schemas")
    private final String[] schemas = new String[]{"urn:ietf:params:scim:schemas:core:2.0:User"};
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="userName")
    private String userName;
    @JsonProperty(value="name")
    private NameDTO name;
    @JsonProperty(value="emails")
    private EmailDTO[] emails;
    @JsonProperty(value="active")
    private boolean active = true;
    @JsonSerialize(using=UserGroupSerializer.class)
    @JsonDeserialize(using=UserGroupDeSerializer.class)
    private GroupDTO[] groups = new GroupDTO[0];
    @JsonProperty(value="entitlements")
    private EntitlementsDTO[] entitlements = new EntitlementsDTO[0];
    @JsonProperty(value="displayName")
    private String displayName;

    public UserDTO() {
    }

    public UserDTO(UserDTO from) {
        this.id = from.id;
        this.userName = from.userName;
        if (from.name != null) {
            this.name = new NameDTO(from.name);
        }
        if (from.emails != null) {
            this.emails = Arrays.copyOf(from.emails, from.emails.length);
        }
        this.active = from.active;
        if (from.groups != null) {
            this.groups = Arrays.copyOf(from.groups, from.groups.length);
        }
        if (from.entitlements != null) {
            this.entitlements = Arrays.copyOf(from.entitlements, from.entitlements.length);
        }
        this.displayName = from.displayName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.emails = new EmailDTO[]{new EmailDTO("work", userName, true)};
    }

    public void setNameDetails(String familyName, String givenName) {
        this.name = new NameDTO();
        this.name.setFamilyName(familyName);
        this.name.setGivenName(givenName);
        this.setDisplayName(givenName + " " + familyName);
    }

    public long getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isActive() {
        return this.active;
    }

    public GroupDTO[] getGroups() {
        return this.groups;
    }

    public EntitlementsDTO[] getEntitlements() {
        return this.entitlements;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="id")
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="active")
    public void setActive(boolean active) {
        this.active = active;
    }

    public void setGroups(GroupDTO[] groups) {
        this.groups = groups;
    }

    @JsonProperty(value="entitlements")
    public void setEntitlements(EntitlementsDTO[] entitlements) {
        this.entitlements = entitlements;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserDTO)) {
            return false;
        }
        UserDTO other = (UserDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        NameDTO this$name = this.name;
        NameDTO other$name = other.name;
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.emails, other.emails)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGroups(), other.getGroups())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEntitlements(), other.getEntitlements())) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        NameDTO $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.emails);
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getGroups());
        result = result * 59 + Arrays.deepHashCode(this.getEntitlements());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String toString() {
        return "UserDTO(schemas=" + Arrays.deepToString(this.schemas) + ", id=" + this.getId() + ", userName=" + this.getUserName() + ", name=" + this.name + ", emails=" + Arrays.deepToString(this.emails) + ", active=" + this.isActive() + ", groups=" + Arrays.deepToString(this.getGroups()) + ", entitlements=" + Arrays.deepToString(this.getEntitlements()) + ", displayName=" + this.getDisplayName() + ")";
    }

    public static class UserGroupDeSerializer
    extends JsonDeserializer<GroupDTO[]> {
        public GroupDTO[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = p.getCodec();
            ArrayNode node = (ArrayNode)oc.readTree(p);
            GroupDTO[] groups = new GroupDTO[node.size()];
            for (int i = 0; i < node.size(); ++i) {
                JsonNode current = node.get(i);
                groups[i] = new GroupDTO();
                groups[i].setId(Long.parseLong(current.get("value").asText()));
                groups[i].setDisplay(current.get("display").asText());
            }
            return groups;
        }
    }

    public static class UserGroupSerializer
    extends JsonSerializer<GroupDTO[]> {
        public void serialize(GroupDTO[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (GroupDTO groupDTO : value) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("display", groupDTO.getDisplay());
                map.put("value", "" + groupDTO.getId());
                gen.writeObject(map);
            }
            gen.writeEndArray();
        }
    }
}

