/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import com.edmunds.rest.databricks.DTO.RunNowDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunLifeCycleStateDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunParametersDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunResultStateDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunStateDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.service.JobService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RunJob {
    public static final long DEFAULT_JOB_TIMEOUT = TimeUnit.DAYS.toMillis(1L);
    public static final long DEFAULT_JOB_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private static Logger log = Logger.getLogger(RunJob.class);
    private JobService service;
    private long jobId;
    private RunParametersDTO runParametersDTO;
    private long timeout;
    private long checkInterval;
    private long runId;
    private long numberInJob;

    public RunJob(JobService service, long jobId, RunParametersDTO runParametersDTO) {
        this(service, jobId, runParametersDTO, DEFAULT_JOB_TIMEOUT, DEFAULT_JOB_CHECK_INTERVAL);
    }

    public RunJob(JobService service, long jobId, RunParametersDTO runParametersDTO, long timeout, long checkInterval) {
        this.service = service;
        this.jobId = jobId;
        this.runParametersDTO = runParametersDTO;
        this.timeout = timeout;
        this.checkInterval = checkInterval;
    }

    public RunResultStateDTO process() throws IOException, DatabricksRestException, InterruptedException {
        this.launchJob();
        RunStateDTO runStateDTO = this.waitForJobFinished();
        RunResultStateDTO resultState = runStateDTO.getResultState();
        switch (resultState) {
            case SUCCESS: {
                log.info((Object)("Job[=" + this.jobId + "] finished successfully. '" + resultState.name() + "' " + runStateDTO.getStateMessage()));
                break;
            }
            case FAILED: 
            case TIMEDOUT: 
            case CANCELED: {
                throw new DatabricksRestException("Job[=" + this.jobId + "] error '" + resultState.name() + "'");
            }
            default: {
                throw new DatabricksRestException("Job[=" + this.jobId + "] error by unknown '" + resultState.name() + "'");
            }
        }
        return resultState;
    }

    public RunNowDTO launchJob() throws IOException, DatabricksRestException {
        RunNowDTO runNowDTO = this.service.runJobNow(this.jobId, this.runParametersDTO);
        this.runId = runNowDTO.getRunId();
        this.numberInJob = runNowDTO.getNumberInJob();
        log.info((Object)("RunJob run-id=" + this.runId + ", [" + this.service.buildRunJobRestUrl(this.jobId, this.numberInJob) + "]"));
        return runNowDTO;
    }

    private RunStateDTO waitForJobFinished() throws IOException, InterruptedException, DatabricksRestException {
        block4: for (long elapsed = 0L; elapsed < this.timeout; elapsed += this.checkInterval) {
            RunDTO runDTO = this.getRunDTO();
            RunStateDTO runStateDTO = runDTO.getState();
            RunLifeCycleStateDTO lifeCycleState = runStateDTO.getLifeCycleState();
            switch (lifeCycleState) {
                case PENDING: 
                case RUNNING: 
                case TERMINATING: {
                    log.info((Object)("Sleep for " + this.checkInterval / 1000L + " secs. Job lifeCycleState '" + lifeCycleState + "'"));
                    Thread.sleep(this.checkInterval);
                    continue block4;
                }
                case SKIPPED: {
                    throw new DatabricksRestException("Job lifeCycleState '" + lifeCycleState + "'. " + runStateDTO.getStateMessage());
                }
            }
            return runStateDTO;
        }
        log.info((Object)("Job did not finished expected " + this.timeout / 1000L + "secs. Cancel run_id=" + this.runId));
        this.cancelJob();
        throw new DatabricksRestException("Job canceled due to timeout " + this.timeout / 1000L + "secs");
    }

    public RunDTO getRunDTO() throws IOException, DatabricksRestException {
        return this.service.getRun(this.runId);
    }

    public void cancelJob() throws IOException, DatabricksRestException {
        this.service.cancelRun(this.runId);
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getRunId() {
        return this.runId;
    }

    public long getNumberInJob() {
        return this.numberInJob;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }
}

