/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import com.edmunds.rest.databricks.DTO.jobs.RunDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunLifeCycleStateDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunResultStateDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RunJob;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public class RunJobs {
    private static Logger log = Logger.getLogger(RunJobs.class);
    private RunJob[] runJobs;
    private long timeout;
    private long checkInterval;

    public RunJobs(RunJob[] runJobs, long timeout, long checkInterval) {
        this.runJobs = runJobs;
        this.timeout = timeout;
        this.checkInterval = checkInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map.Entry<RunJob, Exception>> process() throws InterruptedException {
        ArrayList<RunJob> runningJobs = new ArrayList<RunJob>(this.runJobs.length);
        ArrayList<Map.Entry<RunJob, Exception>> failedJobs = new ArrayList<Map.Entry<RunJob, Exception>>();
        for (RunJob runJob : this.runJobs) {
            try {
                runJob.launchJob();
                runningJobs.add(runJob);
            }
            catch (DatabricksRestException | IOException e) {
                failedJobs.add(new AbstractMap.SimpleEntry<RunJob, Exception>(runJob, e));
            }
        }
        long elapsed = 0L;
        while (!runningJobs.isEmpty()) {
            Thread.sleep(this.checkInterval);
            elapsed += this.checkInterval;
            Iterator runningJobsIterator = runningJobs.iterator();
            while (runningJobsIterator.hasNext()) {
                RunJob currentJob = (RunJob)runningJobsIterator.next();
                try {
                    RunDTO runDTO = currentJob.getRunDTO();
                    if (this.checkJobIsFinished(runDTO)) {
                        log.info((Object)("Job[=" + currentJob.getJobId() + "] Finished"));
                        runningJobsIterator.remove();
                        continue;
                    }
                    log.info((Object)("Job[=" + currentJob.getJobId() + "] Still Running"));
                }
                catch (DatabricksRestException | IOException e) {
                    log.error((Object)("Job[=" + currentJob.getJobId() + "] failed"), (Throwable)e);
                    failedJobs.add(new AbstractMap.SimpleEntry<RunJob, Exception>(currentJob, e));
                    runningJobsIterator.remove();
                }
            }
            if (elapsed <= this.timeout) continue;
            for (RunJob runningJob : runningJobs) {
                try {
                    runningJob.cancelJob();
                }
                catch (DatabricksRestException | IOException e) {
                    log.error((Object)("Failed to cancel Job[=" + runningJob.getJobId() + "]"), (Throwable)e);
                }
                finally {
                    failedJobs.add(new AbstractMap.SimpleEntry<RunJob, DatabricksRestException>(runningJob, new DatabricksRestException("Job canceled due to timeout " + this.timeout / 1000L + "secs")));
                }
            }
            runningJobs.clear();
        }
        return failedJobs;
    }

    private boolean checkJobIsFinished(RunDTO run) throws DatabricksRestException {
        RunLifeCycleStateDTO runLifeCycleState = run.getState().getLifeCycleState();
        if (Objects.equals(runLifeCycleState, RunLifeCycleStateDTO.TERMINATED) || Objects.equals(runLifeCycleState, RunLifeCycleStateDTO.SKIPPED) || Objects.equals(runLifeCycleState, RunLifeCycleStateDTO.INTERNAL_ERROR)) {
            RunResultStateDTO runResultState = run.getState().getResultState();
            if (runResultState != RunResultStateDTO.SUCCESS) {
                throw new DatabricksRestException("Run was terminated with state: " + runResultState);
            }
            return true;
        }
        return false;
    }
}

