/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.restclient;

import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.DatabricksServiceFactory;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.AbstractDatabricksRestClientImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class DatabricksRestClientImpl
extends AbstractDatabricksRestClientImpl {
    private static Logger logger = Logger.getLogger((String)DatabricksRestClientImpl.class.getName());

    public DatabricksRestClientImpl(DatabricksServiceFactory.Builder builder) {
        super(builder.getHost(), builder.getApiVersion(), builder.getMaxRetries(), builder.getRetryInterval(), builder.isRequestSentRetryEnabled());
        if (!(DatabricksRestClientImpl.isNotEmpty(builder.getToken()) || DatabricksRestClientImpl.isNotEmpty(builder.getUsername()) && DatabricksRestClientImpl.isNotEmpty(builder.getPassword()))) {
            throw new IllegalArgumentException("Token or username/password must be set!");
        }
        this.initClient(builder);
    }

    protected void initClient(DatabricksServiceFactory.Builder builder) {
        HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties().setRetryHandler(this.retryHandler).setServiceUnavailableRetryStrategy(this.retryStrategy).setDefaultRequestConfig(this.createRequestConfig(builder));
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        if (DatabricksRestClientImpl.isNotEmpty(builder.getToken())) {
            BasicHeader authHeader = new BasicHeader("Authorization", String.format("Bearer %s", builder.getToken()));
            headers.add(authHeader);
        } else {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.host, 443), (Credentials)new UsernamePasswordCredentials(builder.getUsername(), builder.getPassword()));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        String userAgent = builder.getUserAgent();
        if (userAgent != null && userAgent.length() > 0) {
            BasicHeader userAgentHeader = new BasicHeader("User-Agent", userAgent);
            headers.add(userAgentHeader);
        }
        if (!headers.isEmpty()) {
            clientBuilder.setDefaultHeaders(headers);
        }
        try {
            SSLContext ctx = SSLContext.getDefault();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            clientBuilder = clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.client = clientBuilder.build();
        this.url = String.format("https://%s/api/%s", this.host, this.apiVersion);
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    private RequestConfig createRequestConfig(DatabricksServiceFactory.Builder builder) {
        return RequestConfig.custom().setExpectContinueEnabled(true).setSocketTimeout(builder.getSoTimeout()).setConnectTimeout(builder.getConnectionTimeout()).setConnectionRequestTimeout(builder.getConnectionRequestTimeout()).build();
    }

    @Override
    public byte[] performQuery(RequestMethod requestMethod, String path) throws DatabricksRestException {
        return this.performQuery(requestMethod, path, Collections.emptyMap());
    }

    @Override
    public byte[] performQuery(RequestMethod requestMethod, String path, Map<String, Object> data) throws DatabricksRestException {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpRequestBase method = this.makeHttpMethod(requestMethod, path, data);
            httpResponse = ((CloseableHttpClient)this.client).execute((HttpUriRequest)method);
            byte[] response = this.extractContent((HttpResponse)httpResponse);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            byte[] byArray = response;
            return byArray;
        }
        catch (DatabricksRestException dre) {
            throw dre;
        }
        catch (Exception e) {
            throw new DatabricksRestException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException ioe) {
                logger.debug((Object)"ignore close error", (Throwable)ioe);
            }
        }
    }
}

