/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.restclient;

import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.DatabricksServiceFactory;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.AbstractDatabricksRestClientImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AutoRetryHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

@Deprecated
public final class DatabricksRestClientImpl425
extends AbstractDatabricksRestClientImpl {
    private static Logger logger = Logger.getLogger((String)DatabricksRestClientImpl425.class.getName());
    private boolean isTokenAuth = false;
    private String authToken = null;

    public DatabricksRestClientImpl425(DatabricksServiceFactory.Builder builder) {
        super(builder.getHost(), builder.getApiVersion(), builder.getMaxRetries(), builder.getRetryInterval());
        if (!(DatabricksRestClientImpl425.isNotEmpty(builder.getToken()) || DatabricksRestClientImpl425.isNotEmpty(builder.getUsername()) && DatabricksRestClientImpl425.isNotEmpty(builder.getPassword()))) {
            throw new IllegalArgumentException("Token or username/password must be set!");
        }
        this.initClient(builder);
    }

    protected void initClient(DatabricksServiceFactory.Builder builder) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(httpsScheme);
            BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)builder.getConnectionTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)builder.getSoTimeout());
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
            defaultHttpClient.setHttpRequestRetryHandler(this.retryHandler);
            if (DatabricksRestClientImpl425.isNotEmpty(builder.getToken())) {
                this.isTokenAuth = true;
                this.authToken = builder.getToken();
            } else if (DatabricksRestClientImpl425.isNotEmpty(builder.getUsername()) && DatabricksRestClientImpl425.isNotEmpty(builder.getPassword())) {
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(this.host, 443), (Credentials)new UsernamePasswordCredentials(builder.getUsername(), builder.getPassword()));
            }
            this.client = new AutoRetryHttpClient((HttpClient)defaultHttpClient, this.retryStrategy);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.url = String.format("https://%s/api/%s", this.host, this.apiVersion);
        this.mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    @Override
    public byte[] performQuery(RequestMethod requestMethod, String path) throws DatabricksRestException {
        return this.performQuery(requestMethod, path, Collections.emptyMap());
    }

    @Override
    public byte[] performQuery(RequestMethod requestMethod, String path, Map<String, Object> data) throws DatabricksRestException {
        HttpRequestBase method = null;
        try {
            method = this.makeHttpMethod(requestMethod, path, data);
            if (this.isTokenAuth) {
                method.addHeader("Authorization", String.format("Bearer %s", this.authToken));
            }
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)method);
            byte[] response = this.extractContent(httpResponse);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            byte[] byArray = response;
            return byArray;
        }
        catch (DatabricksRestException dre) {
            throw dre;
        }
        catch (Exception e) {
            throw new DatabricksRestException(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

