/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.DbfsReadDTO;
import com.edmunds.rest.databricks.DTO.dbfs.FileInfoDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.DbfsService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.util.Base64;

public class DbfsServiceImpl
extends DatabricksService
implements DbfsService {
    public DbfsServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    public void rm(String path, boolean recursive) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        data.put("recursive", recursive);
        this.client.performQuery(RequestMethod.POST, "/dbfs/delete", data);
    }

    @Override
    public FileInfoDTO getInfo(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/dbfs/get-status", data);
        return (FileInfoDTO)this.mapper.readValue(responseBody, FileInfoDTO.class);
    }

    @Override
    public FileInfoDTO[] ls(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/dbfs/list", data);
        Map jsonObject = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, FileInfoDTO[]>>(){});
        return (FileInfoDTO[])jsonObject.get("files");
    }

    @Override
    public void mkdirs(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        this.client.performQuery(RequestMethod.POST, "/dbfs/mkdirs", data);
    }

    @Override
    public void mv(String sourcePath, String destinationPath) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("source_path", sourcePath);
        data.put("destination_path", destinationPath);
        this.client.performQuery(RequestMethod.POST, "/dbfs/move", data);
    }

    @Override
    public void write(String path, InputStream inputStream, boolean overwrite) throws IOException, DatabricksRestException {
        long handle = this.openHandle(path, overwrite);
        this.addBlocks(inputStream, handle);
    }

    @Override
    public DbfsReadDTO read(String path, long offset, long length) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        data.put("offset", offset);
        data.put("length", length);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/dbfs/read", data);
        return (DbfsReadDTO)this.mapper.readValue(responseBody, DbfsReadDTO.class);
    }

    @Override
    public DbfsReadDTO read(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/dbfs/read", data);
        return (DbfsReadDTO)this.mapper.readValue(responseBody, DbfsReadDTO.class);
    }

    private long openHandle(String path, boolean overwrite) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        data.put("overwrite", overwrite);
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/dbfs/create", data);
        Map jsonObject = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, Long>>(){});
        return (Long)jsonObject.get("handle");
    }

    private void closeHandle(long handle) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("handle", handle);
        this.client.performQuery(RequestMethod.POST, "/dbfs/close", data);
    }

    private void addBlocks(InputStream inputStream, long handle) throws IOException, DatabricksRestException {
        if (handle != 0L) {
            int read;
            byte[] buffer = new byte[0x100000];
            while ((read = inputStream.read(buffer)) > -1) {
                String data = Base64.encodeBase64String((byte[])Arrays.copyOf(buffer, read));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("handle", handle);
                params.put("data", data);
                this.client.performQuery(RequestMethod.POST, "/dbfs/add-block", params);
            }
            this.closeHandle(handle);
        }
    }
}

