/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.instance_profiles.InstanceProfileDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.InstanceProfilesService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InstanceProfilesServiceImpl
extends DatabricksService
implements InstanceProfilesService {
    private static Logger log = Logger.getLogger(InstanceProfilesServiceImpl.class);
    private static final InstanceProfileDTO[] EMPTY_PROFILE_ARRAY = new InstanceProfileDTO[0];

    public InstanceProfilesServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    public void add(String instanceProfileArn) throws IOException, DatabricksRestException {
        this.add(instanceProfileArn, false);
    }

    @Override
    public void add(String instanceProfileArn, boolean skipValidation) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("instance_profile_arn", instanceProfileArn);
        data.put("skip_validation", skipValidation);
        this.client.performQuery(RequestMethod.POST, "/instance-profiles/add", data);
    }

    @Override
    public InstanceProfileDTO[] list() throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/instance-profiles/list", null);
        Map jsonObject = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, InstanceProfileDTO[]>>(){});
        InstanceProfileDTO[] profiles = (InstanceProfileDTO[])jsonObject.get("instance_profiles");
        return profiles != null ? profiles : EMPTY_PROFILE_ARRAY;
    }

    @Override
    public void remove(String instanceProfileArn) throws IOException, DatabricksRestException {
        if (this.exists(instanceProfileArn)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("instance_profile_arn", instanceProfileArn);
            this.client.performQuery(RequestMethod.POST, "/instance-profiles/remove", data);
        } else {
            log.info((Object)String.format("Instance profile with arn [%s] does not exist", instanceProfileArn));
        }
    }

    @Override
    public boolean exists(String instanceProfileArn) throws IOException, DatabricksRestException {
        InstanceProfileDTO[] profiles;
        for (InstanceProfileDTO profile : profiles = this.list()) {
            if (profile.getInstanceProfileArn() == null || !profile.getInstanceProfileArn().equals(instanceProfileArn)) continue;
            return true;
        }
        return false;
    }
}

