/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.libraries.ClusterLibraryStatusesDTO;
import com.edmunds.rest.databricks.DTO.libraries.LibraryDTO;
import com.edmunds.rest.databricks.DTO.libraries.LibraryFullStatusDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.LibraryService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class LibraryServiceImpl
extends DatabricksService
implements LibraryService {
    private static Logger log = Logger.getLogger(LibraryServiceImpl.class);

    public LibraryServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    public ClusterLibraryStatusesDTO[] allClusterStatuses() throws IOException, DatabricksRestException {
        byte[] response = this.client.performQuery(RequestMethod.GET, "/libraries/all-cluster-statuses", null);
        Map jsonObject = (Map)this.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, ClusterLibraryStatusesDTO[]>>(){});
        return (ClusterLibraryStatusesDTO[])jsonObject.get("statuses");
    }

    @Override
    public ClusterLibraryStatusesDTO clusterStatus(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        byte[] response = this.client.performQuery(RequestMethod.GET, "/libraries/cluster-status", data);
        return (ClusterLibraryStatusesDTO)this.mapper.readValue(response, ClusterLibraryStatusesDTO.class);
    }

    @Override
    public void install(String clusterId, LibraryDTO[] libraries) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        data.put("libraries", libraries);
        this.client.performQuery(RequestMethod.POST, "/libraries/install", data);
    }

    @Override
    public void uninstall(String clusterId, LibraryDTO[] libraries) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        data.put("libraries", libraries);
        this.client.performQuery(RequestMethod.POST, "/libraries/uninstall", data);
    }

    @Override
    public void uninstallAll(String clusterId) throws IOException, DatabricksRestException {
        ClusterLibraryStatusesDTO clusterStatuses = this.clusterStatus(clusterId);
        ArrayList<LibraryDTO> librariesToUninstall = new ArrayList<LibraryDTO>();
        for (LibraryFullStatusDTO libraryStatusDTO : clusterStatuses.getLibraryFullStatuses()) {
            log.info((Object)("Found Library: " + libraryStatusDTO.getLibrary().toString()));
            librariesToUninstall.add(libraryStatusDTO.getLibrary());
        }
        try {
            this.uninstall(clusterId, librariesToUninstall.toArray(new LibraryDTO[librariesToUninstall.size()]));
        }
        catch (DatabricksRestException e) {
            log.error((Object)e);
            throw new DatabricksRestException("Error uninstalling libraries");
        }
    }
}

