/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.scim.ListResponseDTO;
import com.edmunds.rest.databricks.DTO.scim.Operation;
import com.edmunds.rest.databricks.DTO.scim.OperationsDTO;
import com.edmunds.rest.databricks.DTO.scim.group.GroupDTO;
import com.edmunds.rest.databricks.DTO.scim.user.AddUsersToGroupOperation;
import com.edmunds.rest.databricks.DTO.scim.user.RemoveUserFromGroupOperation;
import com.edmunds.rest.databricks.DTO.scim.user.UserDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.ScimService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class ScimServiceImpl
extends DatabricksService
implements ScimService {
    private static final String SCIM_USERS = "/preview/scim/v2/Users";
    private static final String SCIM_GROUPS = "/preview/scim/v2/Groups";

    public ScimServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    private String path(String path, long id) {
        return path + "/" + id;
    }

    @Override
    public UserDTO getUser(long id) throws IOException, DatabricksRestException {
        byte[] response = this.client.performQuery(RequestMethod.GET, this.path(SCIM_USERS, id));
        return (UserDTO)this.mapper.readValue(response, UserDTO.class);
    }

    @Override
    public void deleteUser(long id) throws DatabricksRestException {
        this.client.performQuery(RequestMethod.DELETE, this.path(SCIM_USERS, id));
    }

    @Override
    public ListResponseDTO<UserDTO> listUsers() throws IOException, DatabricksRestException {
        return this.listUsers(null, 1);
    }

    @Override
    public ListResponseDTO<UserDTO> listUsers(String filters) throws IOException, DatabricksRestException {
        return this.listUsers(filters, 1);
    }

    private ListResponseDTO<UserDTO> listUsers(String filters, int startIndex) throws IOException, DatabricksRestException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filters != null) {
            params.put("filter", URLEncoder.encode(filters, "UTF-8"));
        }
        params.put("startIndex", startIndex);
        byte[] response = this.client.performQuery(RequestMethod.GET, SCIM_USERS, params);
        return (ListResponseDTO)this.mapper.readValue(response, (TypeReference)new TypeReference<ListResponseDTO<UserDTO>>(){});
    }

    @Override
    public long createUser(UserDTO userDTO) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)userDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, SCIM_USERS, data);
        UserDTO response = (UserDTO)this.mapper.readValue(responseBody, UserDTO.class);
        userDTO.setId(response.getId());
        return response.getId();
    }

    @Override
    public void editUser(UserDTO userDTO) throws IOException, DatabricksRestException {
        UserDTO userToEdit = new UserDTO(userDTO);
        userToEdit.setId(0L);
        String marshalled = this.mapper.writeValueAsString((Object)userToEdit);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.client.performQuery(RequestMethod.PUT, this.path(SCIM_USERS, userDTO.getId()), data);
    }

    @Override
    public GroupDTO getGroup(long id) throws IOException, DatabricksRestException {
        byte[] response = this.client.performQuery(RequestMethod.GET, this.path(SCIM_GROUPS, id));
        return (GroupDTO)this.mapper.readValue(response, GroupDTO.class);
    }

    @Override
    public void deleteGroup(long id) throws DatabricksRestException {
        this.client.performQuery(RequestMethod.DELETE, this.path(SCIM_GROUPS, id));
    }

    @Override
    public ListResponseDTO<GroupDTO> listGroups() throws IOException, DatabricksRestException {
        return this.listGroups(null, 1);
    }

    @Override
    public ListResponseDTO<GroupDTO> listGroups(String filters) throws IOException, DatabricksRestException {
        return this.listGroups(filters, 1);
    }

    private ListResponseDTO<GroupDTO> listGroups(String filters, int startIndex) throws IOException, DatabricksRestException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filters != null) {
            params.put("filter", URLEncoder.encode(filters, "UTF-8"));
        }
        params.put("startIndex", startIndex);
        byte[] response = this.client.performQuery(RequestMethod.GET, SCIM_GROUPS, params);
        return (ListResponseDTO)this.mapper.readValue(response, (TypeReference)new TypeReference<ListResponseDTO<GroupDTO>>(){});
    }

    @Override
    public long createGroup(GroupDTO group) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)group);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, SCIM_GROUPS, data);
        GroupDTO response = (GroupDTO)this.mapper.readValue(responseBody, GroupDTO.class);
        group.setId(response.getId());
        return response.getId();
    }

    @Override
    public void addUsersToGroup(long groupId, long[] userIds) throws IOException, DatabricksRestException {
        AddUsersToGroupOperation operation = new AddUsersToGroupOperation(userIds);
        OperationsDTO operationsDTO = new OperationsDTO();
        operationsDTO.setOperations(new Operation[]{operation});
        String marshalled = this.mapper.writeValueAsString((Object)operationsDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.client.performQuery(RequestMethod.PATCH, this.path(SCIM_GROUPS, groupId), data);
    }

    @Override
    public void removeUsersFromGroup(long groupId, long[] userIds) throws IOException, DatabricksRestException {
        Operation[] operations = new RemoveUserFromGroupOperation[userIds.length];
        for (int i = 0; i < operations.length; ++i) {
            operations[i] = new RemoveUserFromGroupOperation(userIds[i]);
        }
        OperationsDTO operationsDTO = new OperationsDTO();
        operationsDTO.setOperations(operations);
        String marshalled = this.mapper.writeValueAsString((Object)operationsDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.client.performQuery(RequestMethod.PATCH, this.path(SCIM_GROUPS, groupId), data);
    }
}

