/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.sun.jersey.api.client.ClientRequest;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3Signer {
    protected static final Logger log = LoggerFactory.getLogger(S3Signer.class);
    protected S3Config s3Config;

    S3Signer(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public abstract void sign(ClientRequest var1, String var2, Map<String, String> var3, Map<String, List<Object>> var4);

    protected abstract String getSignature(String var1, byte[] var2);

    protected abstract String getDate(Map<String, String> var1, Map<String, List<Object>> var2);

    public abstract URL generatePresignedUrl(PresignedUrlRequest var1);

    protected abstract SortedMap<String, String> getCanonicalizedHeaders(Map<String, List<Object>> var1, Map<String, String> var2);

    protected byte[] hmac(String algorithm, byte[] secretKey, String message) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secretKey, algorithm));
            byte[] result = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            log.debug("hmac of {} and {}:\n{}", new Object[]{secretKey, message, result});
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(algorithm + " algorithm is not supported on this platform", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("The secret key is not valid", e);
        }
    }

    protected static byte[] hash256(String stringToHash) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] hash = digest.digest(stringToHash.getBytes(StandardCharsets.UTF_8));
        return hash;
    }

    protected static String hexEncode(byte[] arg) {
        String hexString = DatatypeConverter.printHexBinary((byte[])arg);
        if (hexString != null) {
            return hexString.toLowerCase();
        }
        return null;
    }

    protected String trimAndJoin(List<Object> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringBuilder delimited = new StringBuilder();
        Iterator<Object> valuesI = values.iterator();
        while (valuesI.hasNext()) {
            delimited.append(valuesI.next().toString().trim());
            if (!valuesI.hasNext()) continue;
            delimited.append(delimiter);
        }
        return delimited.toString();
    }
}

