/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Signer;
import com.emc.object.s3.jersey.BucketFilter;
import com.emc.object.s3.jersey.NamespaceFilter;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.emc.object.util.RestUtil;
import com.sun.jersey.api.client.ClientRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;

public final class S3SignerV2
extends S3Signer {
    private SortedSet<String> signedParameters = new TreeSet<String>(Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "endpoint", "isstaleallowed"));

    public S3SignerV2(S3Config s3Config) {
        super(s3Config);
        if (s3Config.isSignMetadataSearch()) {
            this.signedParameters.add("query");
            this.signedParameters.add("searchmetadata");
        }
    }

    @Override
    public void sign(ClientRequest request, String resource, Map<String, String> parameters, Map<String, List<Object>> headers) {
        if (this.s3Config.getSessionToken() != null) {
            RestUtil.putSingle(headers, "x-amz-security-token", this.s3Config.getSessionToken());
        }
        String stringToSign = this.getStringToSign(request.getMethod(), resource, parameters, headers);
        String signature = this.getSignature(stringToSign, null);
        RestUtil.putSingle(headers, "Authorization", "AWS " + this.s3Config.getIdentity() + ":" + signature);
    }

    @Override
    protected String getSignature(String stringToSign, byte[] signingKey) {
        return DatatypeConverter.printBase64Binary((byte[])this.hmac("HmacSHA1", this.s3Config.getSecretKey().getBytes(StandardCharsets.UTF_8), stringToSign));
    }

    @Override
    protected String getDate(Map<String, String> parameters, Map<String, List<Object>> headers) {
        String date = RestUtil.getFirstAsString(headers, "Date");
        if (date == null) {
            date = RestUtil.getRequestDate(this.s3Config.getServerClockSkew());
            RestUtil.putSingle(headers, "Date", date);
        }
        if (headers.containsKey("x-amz-date")) {
            date = "";
        }
        if (parameters.containsKey("Expires")) {
            date = parameters.get("Expires");
        }
        return date;
    }

    @Override
    public URL generatePresignedUrl(PresignedUrlRequest request) {
        String namespace = request.getNamespace() != null ? request.getNamespace() : this.s3Config.getNamespace();
        URI uri = this.s3Config.resolvePath(request.getPath(), null);
        String resource = "/" + request.getBucketName() + RestUtil.getEncodedPath(uri);
        if (namespace != null) {
            if (this.s3Config.isUseVHost()) {
                uri = NamespaceFilter.insertNamespace(uri, namespace);
                if (this.s3Config.isSignNamespace()) {
                    resource = "/" + namespace + resource;
                }
            } else {
                log.warn("vHost namespace is disabled, so there is no way to specify a namespace in a pre-signed URL");
            }
        }
        uri = BucketFilter.insertBucket(uri, request.getBucketName(), this.s3Config.isUseVHost());
        Map<String, String> queryParams = request.getQueryParams();
        queryParams.put("AWSAccessKeyId", this.s3Config.getIdentity());
        if (this.s3Config.getSessionToken() != null) {
            queryParams.put("x-amz-security-token", this.s3Config.getSessionToken());
        }
        String stringToSign = this.getStringToSign(request.getMethod().toString(), resource, queryParams, request.getHeaders());
        String signature = this.getSignature(stringToSign, null);
        queryParams.put("Signature", signature);
        try {
            return new URL(uri + this.getCanonicalizedQueryString(request, queryParams));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("generated URL is not well-formed");
        }
    }

    private String getCanonicalizedQueryString(PresignedUrlRequest request, Map<String, String> queryParams) {
        String subresource = request.getSubresource() != null ? request.getSubresource() + "&" : "";
        return "?" + subresource + RestUtil.generateRawQueryString(queryParams);
    }

    String getStringToSign(String method, String resource, Map<String, String> parameters, Map<String, List<Object>> headers) {
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method).append("\n");
        String contentMd5 = RestUtil.getFirstAsString(headers, "Content-MD5");
        if (contentMd5 != null) {
            stringToSign.append(contentMd5);
        }
        stringToSign.append("\n");
        String contentType = RestUtil.getFirstAsString(headers, "Content-Type");
        if (contentType != null) {
            stringToSign.append(contentType);
        }
        stringToSign.append("\n");
        stringToSign.append(this.getDate(parameters, headers));
        stringToSign.append("\n");
        SortedMap<String, String> canonicalizedHeaders = this.getCanonicalizedHeaders(headers, parameters);
        for (String string : canonicalizedHeaders.keySet()) {
            stringToSign.append(string).append(":").append(((String)canonicalizedHeaders.get(string)).trim());
            stringToSign.append("\n");
        }
        stringToSign.append(resource);
        boolean firstParameter = true;
        for (String parameter : this.signedParameters) {
            if (!parameters.containsKey(parameter)) continue;
            stringToSign.append(firstParameter ? "?" : "&").append(parameter);
            String value = parameters.get(parameter);
            if (value != null) {
                stringToSign.append("=").append(value);
            }
            firstParameter = false;
        }
        String string = stringToSign.toString();
        log.debug("stringToSign:\n" + string);
        return string;
    }

    @Override
    protected SortedMap<String, String> getCanonicalizedHeaders(Map<String, List<Object>> headers, Map<String, String> parameters) {
        TreeMap<String, String> canonicalizedHeaders = new TreeMap<String, String>();
        for (String header : headers.keySet()) {
            String lcHeader = header.toLowerCase();
            if (!lcHeader.startsWith("x-amz-") && !lcHeader.startsWith("x-emc-")) continue;
            canonicalizedHeaders.put(lcHeader, this.trimAndJoin(headers.get(header), ","));
        }
        for (String parameter : parameters.keySet()) {
            String lcParameter = parameter.toLowerCase();
            if (!lcParameter.startsWith("x-amz-")) continue;
            canonicalizedHeaders.put(lcParameter, parameters.get(parameter));
        }
        return canonicalizedHeaders;
    }
}

