/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.bean;

import com.emc.object.s3.bean.BucketPolicyAction;
import com.emc.object.s3.bean.PolicyConditionCriteria;
import com.emc.object.s3.bean.PolicyConditionOperator;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"sid", "effect", "rawPrincipal", "actions", "resource", "conditions"})
public class BucketPolicyStatement {
    private String sid;
    private Effect effect;
    private String principal;
    private List<BucketPolicyAction> actions = new ArrayList<BucketPolicyAction>();
    private String resource;
    private Map<PolicyConditionOperator, PolicyConditionCriteria> conditions = new TreeMap<PolicyConditionOperator, PolicyConditionCriteria>();

    @XmlElement(name="Sid")
    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    @XmlElement(name="Effect")
    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    @XmlTransient
    public String getPrincipal() {
        if ("\"*\"".equals(this.principal)) {
            return "*";
        }
        return this.principal;
    }

    @XmlElement(name="Principal")
    @JsonRawValue
    @JsonDeserialize(using=RawDeserializer.class)
    public String getRawPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = "*".equals(principal) ? "\"*\"" : principal;
    }

    public void setRawPrincipal(String principal) {
        this.principal = principal;
    }

    @XmlElement(name="Action")
    public List<BucketPolicyAction> getActions() {
        return this.actions;
    }

    public void setActions(List<BucketPolicyAction> actions) {
        this.actions = actions;
    }

    @XmlElement(name="Resource")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @XmlElementWrapper(name="Condition")
    public Map<PolicyConditionOperator, PolicyConditionCriteria> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<PolicyConditionOperator, PolicyConditionCriteria> conditions) {
        this.conditions = conditions;
    }

    public BucketPolicyStatement withSid(String sid) {
        this.setSid(sid);
        return this;
    }

    public BucketPolicyStatement withEffect(Effect effect) {
        this.setEffect(effect);
        return this;
    }

    public BucketPolicyStatement withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public BucketPolicyStatement withActions(List<BucketPolicyAction> actions) {
        this.setActions(actions);
        return this;
    }

    public BucketPolicyStatement withActions(BucketPolicyAction ... actions) {
        this.setActions(Arrays.asList(actions));
        return this;
    }

    public BucketPolicyStatement withResource(String resource) {
        this.setResource(resource);
        return this;
    }

    public BucketPolicyStatement withConditions(Map<PolicyConditionOperator, PolicyConditionCriteria> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public BucketPolicyStatement withCondition(PolicyConditionOperator operator, PolicyConditionCriteria criteria) {
        this.conditions.put(operator, criteria);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketPolicyStatement that = (BucketPolicyStatement)o;
        if (this.sid != null ? !this.sid.equals(that.sid) : that.sid != null) {
            return false;
        }
        if (this.effect != that.effect) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) {
            return false;
        }
        if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
    }

    public int hashCode() {
        int result = this.sid != null ? this.sid.hashCode() : 0;
        result = 31 * result + (this.effect != null ? this.effect.hashCode() : 0);
        result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        return result;
    }

    public static class RawDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return p.getCodec().readTree(p).toString();
        }
    }

    @XmlEnum
    public static enum Effect {
        Allow,
        Deny;

    }
}

