/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Signer;
import com.emc.object.s3.S3SignerV2;
import com.emc.object.s3.S3SignerV4;
import com.emc.object.s3.VHostUtil;
import com.emc.object.util.RestUtil;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import java.util.Map;

public class AuthorizationFilter
extends ClientFilter {
    private S3Config s3Config;
    private S3Signer signer;

    public AuthorizationFilter(S3Config s3Config) {
        this.s3Config = s3Config;
        this.signer = s3Config.isUseV2Signer() ? new S3SignerV2(s3Config) : new S3SignerV4(s3Config);
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        if (this.s3Config.getUserAgent() != null) {
            request.getHeaders().putSingle((Object)"User-Agent", (Object)this.s3Config.getUserAgent());
        }
        if (this.s3Config.getIdentity() != null) {
            Map<String, String> parameters = RestUtil.getQueryParameterMap(request.getURI().getRawQuery());
            String resource = VHostUtil.getResourceString(this.s3Config, (String)request.getProperties().get("com.emc.object.namespace"), (String)request.getProperties().get("com.emc.object.s3.bucketName"), RestUtil.getEncodedPath(request.getURI()));
            this.signer.sign(request, resource, parameters, (Map<String, List<Object>>)request.getHeaders());
        }
        return this.getNext().handle(request);
    }
}

