/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Exception;
import com.emc.object.util.RestUtil;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(request);
        if (response.getStatus() > 299) {
            if (response.getStatus() == 403) {
                long skew;
                Date clientTime = RestUtil.amzHeaderParse(RestUtil.getFirstAsString(request.getHeaders(), "x-amz-date"));
                if (clientTime == null) {
                    clientTime = RestUtil.headerParse(RestUtil.getFirstAsString(request.getHeaders(), "Date"));
                }
                Date serverTime = RestUtil.headerParse(RestUtil.getFirstAsString(response.getHeaders(), "Date"));
                if (clientTime != null && serverTime != null && Math.abs(skew = clientTime.getTime() - serverTime.getTime()) > 300000L) {
                    log.warn("clock skew detected! client is more than 5 minutes off from server (" + skew + "ms)");
                }
            }
            if (response.hasEntity()) {
                throw ErrorFilter.parseErrorResponse(new InputStreamReader(response.getEntityInputStream()), response.getStatus());
            }
            try {
                response.close();
            }
            catch (Throwable t) {
                log.warn("could not close response after error", t);
            }
            Response.StatusType st = response.getStatusInfo();
            throw new S3Exception(st.getReasonPhrase(), st.getStatusCode(), this.guessStatus(st.getStatusCode()), (String)response.getHeaders().getFirst((Object)"x-amz-request-id"));
        }
        return response;
    }

    private String guessStatus(int statusCode) {
        switch (statusCode) {
            case 400: {
                return "InvalidArgument";
            }
            case 403: {
                return "AccessDenied";
            }
            case 404: {
                return "NoSuchKey";
            }
            case 405: {
                return "MethodNotAllowed";
            }
            case 500: {
                return "InternalError";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S3Exception parseErrorResponse(Reader reader, int statusCode) {
        Document d;
        SAXReader saxReader = new SAXReader();
        try {
            d = saxReader.read(reader);
        }
        catch (Throwable t) {
            S3Exception s3Exception = new S3Exception("could not parse error response", statusCode, t);
            return s3Exception;
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable t) {
                log.warn("could not close reader", t);
            }
        }
        String code = d.getRootElement().elementText("Code");
        String message = d.getRootElement().elementText("Message");
        String requestId = d.getRootElement().elementText("RequestId");
        if (code == null && message == null) {
            return new S3Exception("no code or message in error response", statusCode);
        }
        log.debug("Error: {}, message: {}, requestId: {}", new Object[]{code, message, requestId});
        return new S3Exception(message, statusCode, code, requestId);
    }
}

