/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DeleteObjectRequest
extends S3ObjectRequest {
    private String versionId;
    private Date ifUnmodifiedSince;
    private String ifMatch;
    private Boolean bypassGovernanceRetention;

    public DeleteObjectRequest(String bucketName, String key) {
        super(Method.DELETE, bucketName, key, null);
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        if (this.versionId != null) {
            queryParams.put("versionId", this.versionId);
        }
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.ifUnmodifiedSince != null) {
            RestUtil.putSingle(headers, "If-Unmodified-Since", RestUtil.headerFormat(this.ifUnmodifiedSince));
        }
        if (this.ifMatch != null) {
            RestUtil.putSingle(headers, "If-Match", this.ifMatch);
        }
        if (this.bypassGovernanceRetention != null) {
            RestUtil.putSingle(headers, "x-amz-bypass-governance-retention", this.bypassGovernanceRetention.toString());
        }
        return headers;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Date getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public boolean getBypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.bypassGovernanceRetention = bypassGovernanceRetention;
    }

    public DeleteObjectRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public DeleteObjectRequest withIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.setIfUnmodifiedSince(ifUnmodifiedSince);
        return this;
    }

    public DeleteObjectRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public DeleteObjectRequest withBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.setBypassGovernanceRetention(bypassGovernanceRetention);
        return this;
    }
}

