/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.bean.EncodingType;
import com.emc.object.s3.request.S3ObjectRequest;
import java.util.Map;

public class ListPartsRequest
extends S3ObjectRequest {
    private String uploadId;
    private Integer maxParts;
    private String marker;
    private EncodingType encodingType;

    public ListPartsRequest(String bucketName, String key, String uploadId) {
        super(Method.GET, bucketName, key, null);
        this.uploadId = uploadId;
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        queryParams.put("uploadId", this.uploadId);
        if (this.maxParts != null) {
            queryParams.put("max-parts", this.maxParts.toString());
        }
        if (this.marker != null) {
            queryParams.put("part-number-marker", this.marker);
        }
        if (this.encodingType != null) {
            queryParams.put("encoding-type", this.encodingType.toString());
        }
        return queryParams;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Integer getMaxParts() {
        return this.maxParts;
    }

    public void setMaxParts(Integer maxParts) {
        this.maxParts = maxParts;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public ListPartsRequest withMaxParts(Integer maxParts) {
        this.setMaxParts(maxParts);
        return this;
    }

    public ListPartsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public ListPartsRequest withEncodingType(EncodingType encodingType) {
        this.setEncodingType(encodingType);
        return this;
    }
}

