/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.request.ResponseHeaderOverride;
import com.emc.object.s3.request.S3ObjectRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PresignedUrlRequest
extends S3ObjectRequest {
    private Date expirationTime;
    private Method method;
    private String versionId;
    private S3ObjectMetadata objectMetadata;
    private Map<ResponseHeaderOverride, String> headerOverrides = new HashMap<ResponseHeaderOverride, String>();

    public PresignedUrlRequest(Method method, String bucketName, String key, Date expirationTime) {
        super(method, bucketName, key, null);
        this.method = method;
        this.expirationTime = expirationTime;
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        if (this.versionId != null) {
            queryParams.put("versionId", this.versionId);
        }
        queryParams.put("Expires", Long.toString(this.expirationTime.getTime() / 1000L));
        for (ResponseHeaderOverride override : this.headerOverrides.keySet()) {
            queryParams.put(override.getQueryParam(), this.headerOverrides.get((Object)override));
        }
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.objectMetadata != null) {
            headers.putAll(this.objectMetadata.toHeaders());
        }
        return headers;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public Map<ResponseHeaderOverride, String> getHeaderOverrides() {
        return this.headerOverrides;
    }

    public void setHeaderOverrides(Map<ResponseHeaderOverride, String> headerOverrides) {
        this.headerOverrides = headerOverrides;
    }

    public PresignedUrlRequest withMethod(Method method) {
        this.setMethod(method);
        return this;
    }

    public PresignedUrlRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public PresignedUrlRequest withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public PresignedUrlRequest headerOverride(ResponseHeaderOverride override, String value) {
        this.headerOverrides.put(override, value);
        return this;
    }
}

