/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.bean.EncodingType;
import com.emc.object.s3.request.AbstractBucketRequest;
import com.emc.object.util.RestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueryObjectsRequest
extends AbstractBucketRequest {
    private String prefix;
    private String delimiter;
    private Integer maxKeys;
    private String marker;
    private String query;
    private List<String> attributes;
    private String sorted;
    private boolean includeOlderVersions = false;
    private EncodingType encodingType;

    public QueryObjectsRequest(String bucketName) {
        super(Method.GET, bucketName, "", null);
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> paramMap = super.getQueryParams();
        if (this.prefix != null) {
            paramMap.put("prefix", this.prefix);
        }
        if (this.delimiter != null) {
            paramMap.put("delimiter", this.delimiter);
        }
        if (this.maxKeys != null) {
            paramMap.put("max-keys", this.maxKeys.toString());
        }
        if (this.marker != null) {
            paramMap.put("marker", this.marker);
        }
        if (this.query != null) {
            paramMap.put("query", this.query);
        }
        if (this.attributes != null && this.attributes.size() >= 1) {
            paramMap.put("attributes", QueryObjectsRequest.formatAttributes(this.attributes));
        }
        if (this.sorted != null) {
            paramMap.put("sorted", this.sorted);
        }
        if (this.includeOlderVersions) {
            paramMap.put("include-older-versions", "true");
        }
        if (this.encodingType != null) {
            paramMap.put("encoding-type", this.encodingType.toString());
        }
        return paramMap;
    }

    private static String formatAttributes(List<String> attributes) {
        return RestUtil.join(",", attributes);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public String getSorted() {
        return this.sorted;
    }

    public void setSorted(String sorted) {
        this.sorted = sorted;
    }

    public boolean getIncludeOlderVersions() {
        return this.includeOlderVersions;
    }

    public void setIncludeOlderVersions(boolean includeOlderVersions) {
        this.includeOlderVersions = includeOlderVersions;
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public QueryObjectsRequest withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public QueryObjectsRequest withDelimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public QueryObjectsRequest withMaxKeys(Integer maxKeys) {
        this.setMaxKeys(maxKeys);
        return this;
    }

    public QueryObjectsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public QueryObjectsRequest withQuery(String query) {
        this.setQuery(query);
        return this;
    }

    public QueryObjectsRequest withAttributes(List<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public synchronized QueryObjectsRequest withAttribute(String attribute) {
        List<String> attributes = this.getAttributes();
        if (attributes == null) {
            attributes = new ArrayList<String>();
        }
        attributes.add(attribute);
        this.setAttributes(attributes);
        return this;
    }

    public QueryObjectsRequest withSorted(String sorted) {
        this.setSorted(sorted);
        return this;
    }

    public QueryObjectsRequest withIncludeOlderVersions(boolean includeOlderVersions) {
        this.setIncludeOlderVersions(includeOlderVersions);
        return this;
    }

    public QueryObjectsRequest withEncodingType(EncodingType encodingType) {
        this.setEncodingType(encodingType);
        return this;
    }
}

