/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class UploadPartRequest
extends S3ObjectRequest
implements EntityRequest {
    private String uploadId;
    private int partNumber;
    private Object object;
    private Long contentLength;
    private String contentMd5;

    public UploadPartRequest(String bucketName, String key, String uploadId, int partNumber, Object object) {
        super(Method.PUT, bucketName, key, null);
        this.uploadId = uploadId;
        this.partNumber = partNumber;
        this.object = object;
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        queryParams.put("uploadId", this.uploadId);
        queryParams.put("partNumber", Integer.toString(this.partNumber));
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.contentMd5 != null) {
            RestUtil.putSingle(headers, "Content-MD5", this.contentMd5);
        }
        return headers;
    }

    @Override
    public Object getEntity() {
        return this.getObject();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public boolean isChunkable() {
        return true;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public UploadPartRequest withObject(Object object) {
        this.setObject(object);
        return this;
    }

    public UploadPartRequest withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public UploadPartRequest withContentMd5(String contentMd5) {
        this.setContentMd5(contentMd5);
        return this;
    }
}

