/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import com.emc.object.util.ChecksumAlgorithm;
import com.emc.object.util.ChecksumValue;

public class ChecksumValueImpl
extends ChecksumValue {
    private ChecksumAlgorithm algorithm;
    private long offset;
    private byte[] byteValue;
    private String hexValue;

    public ChecksumValueImpl(ChecksumAlgorithm algorithm, long offset, byte[] byteValue) {
        this(algorithm, offset, byteValue, null);
    }

    public ChecksumValueImpl(ChecksumAlgorithm algorithm, long offset, String hexValue) {
        this(algorithm, offset, null, hexValue);
    }

    public ChecksumValueImpl(ChecksumAlgorithm algorithm, long offset, byte[] byteValue, String hexValue) {
        this.algorithm = algorithm;
        this.offset = offset;
        this.byteValue = byteValue;
        if (hexValue != null) {
            this.hexValue = hexValue.replaceAll("\"", "").trim();
        }
    }

    public ChecksumValueImpl(String headerValue) {
        String[] parts = headerValue.split("/");
        this.algorithm = ChecksumAlgorithm.valueOf(parts[0]);
        if (parts.length > 2) {
            this.offset = Long.parseLong(parts[1]);
            this.hexValue = parts[2];
        } else {
            this.hexValue = parts[1];
        }
    }

    @Override
    public ChecksumAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public byte[] getByteValue() {
        return this.byteValue;
    }

    @Override
    public String getHexValue() {
        return this.hexValue;
    }
}

