/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class Iso8601DateAdapter
extends XmlAdapter<String, Date> {
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd";
    private static final ThreadLocal<DateFormat> iso8601Format = new ThreadLocal();

    public Date unmarshal(String s) throws Exception {
        return Iso8601DateAdapter.getFormat().parse(s);
    }

    public String marshal(Date date) throws Exception {
        return Iso8601DateAdapter.getFormat().format(date);
    }

    public static DateFormat getFormat() {
        DateFormat format = iso8601Format.get();
        if (format == null) {
            format = new SimpleDateFormat(ISO_8601_FORMAT);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            iso8601Format.set(format);
        }
        return format;
    }
}

