/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class RestUtil {
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MATCH = "If-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_HOST = "Host";
    public static final String EMC_PREFIX = "x-emc-";
    public static final String EMC_APPEND_OFFSET = "x-emc-append-offset";
    public static final String EMC_CONTENT_MD5 = "x-emc-content-md5";
    public static final String EMC_FS_ENABLED = "x-emc-file-system-access-enabled";
    public static final String EMC_MTIME = "x-emc-mtime";
    public static final String EMC_NAMESPACE = "x-emc-namespace";
    public static final String EMC_VPOOL = "x-emc-dataservice-vpool";
    public static final String EMC_STALE_READ_ALLOWED = "x-emc-is-stale-allowed";
    public static final String EMC_ENCRYPTION_ENABLED = "x-emc-server-side-encryption-enabled";
    public static final String EMC_RETENTION_PERIOD = "x-emc-retention-period";
    public static final String EMC_RETENTION_POLICY = "x-emc-retention-policy";
    public static final String EMC_METADATA_SEARCH = "x-emc-metadata-search";
    public static final String EMC_COPY_MODE = "x-emc-copy-mode";
    public static final String EMC_MULTIPART_COPY = "x-emc-multipart-copy";
    public static final String EMC_EMPTY_BUCKET = "x-emc-empty-bucket";
    public static final String TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TYPE_APPLICATION_XML = "application/xml";
    public static final String TYPE_APPLICATION_JSON = "application/json";
    public static final String PROPERTY_NAMESPACE = "com.emc.object.namespace";
    public static final String PROPERTY_USER_METADATA = "com.emc.object.userMetadata";
    public static final String PROPERTY_ENCODE_ENTITY = "com.emc.object.codec.encodeEntity";
    public static final String PROPERTY_DECODE_ENTITY = "com.emc.object.codec.decodeEntity";
    public static final String PROPERTY_KEEP_ENCODE_HEADERS = "com.emc.object.codec.keepEncodeHeaders";
    public static final String PROPERTY_VERIFY_READ_CHECKSUM = "com.emc.object.verifyReadChecksum";
    public static final String PROPERTY_VERIFY_WRITE_CHECKSUM = "com.emc.object.verifyWriteChecksum";
    public static final String PROPERTY_GENERATE_CONTENT_MD5 = "com.emc.object.generateContentMd5";
    public static final int STATUS_REDIRECT = 301;
    public static final int STATUS_UNAUTHORIZED = 403;
    public static final int STATUS_NOT_FOUND = 404;
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final DateTimeFormatter iso8601MillisecondFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(TimeZone.getTimeZone("UTC").toZoneId());
    private static final String HEADER_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String AMZ_DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final ThreadLocal<DateFormat> headerFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat format = new SimpleDateFormat(HEADER_FORMAT, Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    });
    private static final ThreadLocal<CharsetEncoder> utf8Encoder = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static <T> String getFirstAsString(Map<String, List<T>> multiValueMap, String key) {
        return RestUtil.getFirstAsString(multiValueMap, key, false);
    }

    public static <T> String getFirstAsString(Map<String, List<T>> multiValueMap, String key, boolean stripQuotes) {
        List<T> values = multiValueMap.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        T value = values.get(0);
        if (value == null) {
            return null;
        }
        return stripQuotes ? RestUtil.stripQuotes(value.toString()) : value.toString();
    }

    public static String stripQuotes(String value) {
        if (value == null) {
            return null;
        }
        int start = 0;
        int end = value.length();
        if (value.charAt(0) == '\"') {
            start = 1;
        }
        if (value.charAt(value.length() - 1) == '\"') {
            end = value.length() - 1;
        }
        return value.substring(start, end);
    }

    public static void putSingle(Map<String, List<Object>> multiValueMap, String key, Object value) {
        RestUtil.put(multiValueMap, key, value, true);
    }

    public static void add(Map<String, List<Object>> multiValueMap, String key, Object value) {
        RestUtil.put(multiValueMap, key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(Map<String, List<Object>> multiValueMap, String key, Object value, boolean single) {
        Map<String, List<Object>> map = multiValueMap;
        synchronized (map) {
            if (value == null) {
                if (single) {
                    multiValueMap.remove(key);
                }
                return;
            }
            List<Object> values = multiValueMap.get(key);
            if (values == null) {
                values = new ArrayList<Object>();
                multiValueMap.put(key, values);
            } else if (single) {
                values.clear();
            }
            values.add(value);
        }
    }

    public static Map<String, String> getQueryParameterMap(String queryString) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (queryString != null && queryString.trim().length() > 0) {
            for (String pair : queryString.split("&")) {
                String value;
                int equals = pair.indexOf(61);
                if (equals == 0) {
                    throw new IllegalArgumentException("invalid query parameter: " + pair);
                }
                String key = equals > 0 ? pair.substring(0, equals) : pair;
                String string = value = equals > 0 ? pair.substring(equals + 1) : null;
                if (key.trim().length() == 0) {
                    throw new IllegalArgumentException("query parameters must have a name");
                }
                parameters.put(RestUtil.urlDecode(key), RestUtil.urlDecode(value));
            }
        }
        return parameters;
    }

    public static String generateQueryString(Map<String, String> parameterMap) {
        return RestUtil.generateRawQueryString(parameterMap);
    }

    public static String generateRawQueryString(Map<String, String> parameterMap) {
        StringBuilder query = new StringBuilder();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            Iterator<String> paramI = parameterMap.keySet().iterator();
            while (paramI.hasNext()) {
                String name = paramI.next();
                query.append(RestUtil.urlEncode(name));
                if (parameterMap.get(name) != null) {
                    query.append("=").append(RestUtil.urlEncode(parameterMap.get(name)));
                }
                if (!paramI.hasNext()) continue;
                query.append("&");
            }
        }
        return query.toString();
    }

    public static String getRequestDate(long clockSkew) {
        return RestUtil.headerFormat(new Date(System.currentTimeMillis() + clockSkew));
    }

    public static String headerFormat(Date date) {
        if (date == null) {
            return null;
        }
        return headerFormat.get().format(date);
    }

    public static Date headerParse(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return headerFormat.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid date header: " + dateString, e);
        }
    }

    public static Date amzHeaderParse(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(AMZ_DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = sdf.parse(dateString);
            sdf.applyPattern(HEADER_FORMAT);
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid date header: " + dateString, e);
        }
    }

    public static String getEncodedPath(URI uri) {
        String rawUri = uri.toASCIIString();
        String path = rawUri.substring(rawUri.indexOf("/", 9));
        if (path.contains("?")) {
            path = path.substring(0, path.indexOf("?"));
        }
        if (path.contains("#")) {
            path = path.substring(0, path.indexOf("#"));
        }
        return path;
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public static String urlDecode(String value) {
        return RestUtil.urlDecode(value, true);
    }

    public static String urlDecode(String value, boolean preservePlus) {
        if (value == null) {
            return null;
        }
        try {
            if (preservePlus) {
                value = value.replace("+", "%2B");
            }
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public static URI buildUri(String scheme, String host, int port, String path, String rawQuery, String rawFragment) throws URISyntaxException {
        URI uri = new URI(scheme, null, host, port, path, null, null);
        String uriString = RestUtil.toASCIIString(uri);
        if (rawQuery != null) {
            uriString = uriString + "?" + rawQuery;
        }
        if (rawFragment != null) {
            uriString = uriString + "#" + rawFragment;
        }
        uriString = uriString.replace("[", "%5B").replace("]", "%5D");
        if (path.contains("//")) {
            uriString = scheme != null ? uriString.substring(0, 8) + uriString.substring(8).replaceAll("//", "/%2F") : uriString.replaceAll("//", "/%2F");
        }
        uriString = uriString.replace("+", "%2B");
        return new URI(uriString);
    }

    public static String toASCIIString(URI u) {
        String s = RestUtil.defineString(u);
        return RestUtil.encode(s);
    }

    private static String defineString(URI u) {
        StringBuilder sb = new StringBuilder();
        if (u.getScheme() != null) {
            sb.append(u.getScheme());
            sb.append(':');
        }
        if (u.isOpaque()) {
            sb.append(u.getRawSchemeSpecificPart());
        } else {
            if (u.getHost() != null) {
                boolean needBrackets;
                sb.append("//");
                if (u.getUserInfo() != null) {
                    sb.append(u.getUserInfo());
                    sb.append('@');
                }
                boolean bl = needBrackets = u.getHost().indexOf(58) >= 0 && !u.getHost().startsWith("[") && !u.getHost().endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(u.getHost());
                if (needBrackets) {
                    sb.append(']');
                }
                if (u.getPort() != -1) {
                    sb.append(':');
                    sb.append(u.getPort());
                }
            } else if (u.getRawAuthority() != null) {
                sb.append("//");
                sb.append(u.getRawAuthority());
            }
            if (u.getRawPath() != null) {
                sb.append(u.getRawPath());
            }
            if (u.getRawQuery() != null) {
                sb.append('?');
                sb.append(u.getRawQuery());
            }
        }
        if (u.getRawFragment() != null) {
            sb.append('#');
            sb.append(u.getRawFragment());
        }
        return sb.toString();
    }

    private static String encode(String s) {
        ByteBuffer bb;
        block6: {
            int n = s.length();
            if (n == 0) {
                return s;
            }
            int i = 0;
            while (s.charAt(i) < '\u0080') {
                if (++i < n) continue;
                return s;
            }
            bb = null;
            try {
                bb = utf8Encoder.get().encode(CharBuffer.wrap(s));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (b >= 128) {
                RestUtil.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b >> 0 & 0xF]);
    }

    public static URI replaceHost(URI uri, String host) throws URISyntaxException {
        return RestUtil.buildUri(uri.getScheme(), host, uri.getPort(), uri.getPath(), uri.getRawQuery(), uri.getRawFragment());
    }

    public static URI replacePath(URI uri, String path) throws URISyntaxException {
        return RestUtil.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), path, uri.getRawQuery(), uri.getRawFragment());
    }

    public static String join(String separator, Iterable<String> items) {
        if (separator == null) {
            throw new IllegalArgumentException("separator argument is null");
        }
        if (items == null) {
            throw new IllegalArgumentException("items argument is null");
        }
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    private RestUtil() {
    }
}

