/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.Locale;

public class FTPFileFactory {
    public static String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.12 2006/05/24 11:35:54 bruceb Exp $";
    private Logger log = Logger.getLogger(class$com$enterprisedt$net$ftp$FTPFileFactory != null ? class$com$enterprisedt$net$ftp$FTPFileFactory : (class$com$enterprisedt$net$ftp$FTPFileFactory = FTPFileFactory.class$("com.enterprisedt.net.ftp.FTPFileFactory")));
    static final String WINDOWS_STR = "WINDOWS";
    static final String UNIX_STR = "UNIX";
    static final String VMS_STR = "VMS";
    private String system;
    private FTPFileParser windows = new WindowsFileParser();
    private FTPFileParser unix = new UnixFileParser();
    private FTPFileParser vms = new VMSFileParser();
    private FTPFileParser parser;
    private boolean usingVMS = false;
    private boolean rotateParsers = true;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$FTPFileFactory;

    public FTPFileFactory(String system) throws FTPException {
        this.setParser(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.parser = parser;
        this.rotateParsers = false;
    }

    public void setLocale(Locale locale) {
        this.windows.setLocale(locale);
        this.unix.setLocale(locale);
        this.vms.setLocale(locale);
        this.parser.setLocale(locale);
    }

    private void setParser(String system) {
        this.system = system;
        if (system.toUpperCase().startsWith(WINDOWS_STR)) {
            this.parser = this.windows;
        } else if (system.toUpperCase().startsWith(UNIX_STR)) {
            this.parser = this.unix;
        } else if (system.toUpperCase().startsWith(VMS_STR)) {
            this.parser = this.vms;
            this.usingVMS = true;
        } else {
            this.parser = this.unix;
            this.log.warn("Unknown SYST '" + system + "' - defaulting to Unix parsing");
        }
    }

    public FTPFile[] parse(String[] files) throws ParseException {
        FTPFile[] temp = new FTPFile[files.length];
        if (files.length == 0) {
            return temp;
        }
        int count = 0;
        boolean checkedUnix = false;
        boolean reparse = false;
        int reparseCount = 1;
        int i = 0;
        while (i < files.length) {
            if (reparse) {
                i -= reparseCount;
                reparse = false;
                reparseCount = 1;
            }
            try {
                if (files[i] != null && files[i].trim().length() != 0) {
                    if (!checkedUnix && this.parser != this.unix && UnixFileParser.isUnix(files[i])) {
                        this.parser = this.unix;
                        checkedUnix = true;
                        this.log.info("Swapping Windows parser to Unix");
                    }
                    FTPFile file = null;
                    if (this.usingVMS) {
                        reparseCount = 1;
                        StringBuffer filename = new StringBuffer(files[i]);
                        while (i + 1 < files.length && files[i + 1].indexOf(59) < 0) {
                            filename.append(" ").append(files[i + 1]);
                            ++i;
                            ++reparseCount;
                        }
                        file = this.parser.parse(filename.toString());
                    } else {
                        file = this.parser.parse(files[i]);
                    }
                    if (file != null) {
                        temp[count++] = file;
                    }
                }
            }
            catch (ParseException ex) {
                StringBuffer msg = new StringBuffer("Failed to parse line '");
                msg.append(files[i]).append("' (").append(ex.getMessage()).append(")");
                this.log.info(msg.toString());
                if (this.rotateParsers) {
                    this.rotateParsers = false;
                    this.rotateParsers();
                    reparse = true;
                }
                throw new ParseException(msg.toString(), ex.getErrorOffset());
            }
            ++i;
        }
        FTPFile[] result = new FTPFile[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    private void rotateParsers() {
        this.usingVMS = false;
        if (this.parser == this.unix) {
            this.parser = this.windows;
            this.log.info("Rotated parser to Windows");
        } else if (this.parser == this.windows) {
            this.parser = this.unix;
            this.log.info("Rotated parser to Unix");
        }
    }

    public String getSystem() {
        return this.system;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

