/*
 * Decompiled with CFR 0.152.
 */
package com.epages.wiremock.starter;

import com.epages.wiremock.starter.WireMockProperties;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WireMockServer.class})
@ConditionalOnProperty(name={"wiremock.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={WireMockProperties.class})
public class WireMockAutoConfiguration {
    private static final Log log = LogFactory.getLog(WireMockAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public WireMockConfiguration wireMockConfiguration(WireMockProperties properties) {
        WireMockConfiguration config = WireMockConfiguration.options();
        if (properties.getPort() > 0) {
            log.info((Object)("Starting WireMock on port " + properties.getPort()));
            config.port(properties.getPort());
        } else {
            log.info((Object)"Starting WireMock on dynamic port");
            config.dynamicPort();
        }
        if (properties.getStubPath() != null) {
            config.fileSource((FileSource)new ClasspathFileSource(properties.getStubPath()));
        }
        config.extensions(new Extension[]{new ResponseTemplateTransformer(false)});
        return config;
    }

    @Bean
    public WireMockServer wireMockServer(WireMockConfiguration config) {
        return new WireMockServer((Options)config);
    }
}

