/*
 * Decompiled with CFR 0.152.
 */
package com.epages.wiremock.starter;

import com.epages.wiremock.starter.InetUtils;
import com.epages.wiremock.starter.WireMockTest;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.util.ReflectionTestUtils;

class WireMockListener
extends AbstractTestExecutionListener
implements Ordered {
    private WireMockTest wireMockAnnotation;

    WireMockListener() {
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (this.wireMockAnnotation == null) {
            return;
        }
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        ((WireMockServer)applicationContext.getBean(WireMockServer.class)).start();
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        this.wireMockAnnotation = testContext.getTestClass().getAnnotation(WireMockTest.class);
        if (this.wireMockAnnotation == null) {
            return;
        }
        int port = this.wireMockAnnotation.port() > 0 ? this.wireMockAnnotation.port() : InetUtils.getFreeServerPort();
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("wiremock.port=" + port);
        properties.add("wiremock.enabled=true");
        properties.add("wiremock.stubPath=" + this.wireMockAnnotation.stubPath());
        properties.add("ribbon.eureka.enabled=false");
        for (String service : this.wireMockAnnotation.ribbonServices()) {
            properties.add(service + ".ribbon.listOfServers=localhost:" + port);
        }
        this.addPropertySourceProperties(testContext, properties.toArray(new String[0]));
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (this.wireMockAnnotation == null) {
            return;
        }
        WireMockTest methodAnnotation = testContext.getTestMethod().getAnnotation(WireMockTest.class);
        String stubPath = "";
        if (this.wireMockAnnotation.stubPath() != null) {
            stubPath = this.wireMockAnnotation.stubPath();
        }
        if (methodAnnotation != null && methodAnnotation.stubPath() != null) {
            stubPath = stubPath + "/" + methodAnnotation.stubPath();
        }
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        WireMockServer server = (WireMockServer)applicationContext.getBean(WireMockServer.class);
        server.resetMappings();
        if (!stubPath.isEmpty()) {
            server.loadMappingsUsing((MappingsLoader)new JsonFileMappingsSource((FileSource)new ClasspathFileSource(stubPath)));
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.wireMockAnnotation == null) {
            return;
        }
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        ((WireMockServer)applicationContext.getBean(WireMockServer.class)).resetToDefaultMappings();
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        if (this.wireMockAnnotation == null) {
            return;
        }
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        ((WireMockServer)applicationContext.getBean(WireMockServer.class)).stop();
    }

    private void addPropertySourceProperties(TestContext testContext, String[] properties) {
        try {
            MergedContextConfiguration configuration = (MergedContextConfiguration)ReflectionTestUtils.getField((Object)testContext, (String)"mergedContextConfiguration");
            new MergedContextConfigurationProperties(configuration).add(properties, new String[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class MergedContextConfigurationProperties {
        private final MergedContextConfiguration configuration;

        MergedContextConfigurationProperties(MergedContextConfiguration configuration) {
            this.configuration = configuration;
        }

        void add(String[] properties, String ... additional) {
            LinkedHashSet<String> merged = new LinkedHashSet<String>(Arrays.asList(this.configuration.getPropertySourceProperties()));
            merged.addAll(Arrays.asList(properties));
            merged.addAll(Arrays.asList(additional));
            ReflectionTestUtils.setField((Object)this.configuration, (String)"propertySourceProperties", (Object)merged.toArray(new String[merged.size()]));
        }
    }
}

