/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

public enum MESSAGE_TYPE {
    STRUCTURE("Structure"),
    REGISTRY_INTERFACE("RegistryInterface"),
    QUERY("QueryMessage"),
    GENERIC_DATA("GenericData"),
    UTILITY_DATA("UtilityData"),
    COMPACT_DATA("CompactData"),
    CROSS_SECTIONAL_DATA("CrossSectionalData"),
    GENERIC_METADATA("GenericMetadata"),
    METADATA_REPORT("MetadataReport"),
    MESSAGE_GROUP("MessageGroup"),
    SDMX_EDI("EDI"),
    ERROR("Error"),
    UNKNOWN("Unknown");

    private String nodeName;

    private MESSAGE_TYPE(String nodeName) {
        this.nodeName = nodeName;
    }

    public static MESSAGE_TYPE parseString(String messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException("MESSAGE_TYPE.parseString can not parse null");
        }
        if (messageType.equals("StructureSpecificTimeSeriesData") || messageType.equals("StructureSpecificData")) {
            return COMPACT_DATA;
        }
        if (messageType.equals("GenericTimeSeriesData")) {
            return GENERIC_DATA;
        }
        if (messageType.equals("GenericDataQuery")) {
            return QUERY;
        }
        if (messageType.equals("StructureSpecificDataQuery")) {
            return QUERY;
        }
        if (messageType.equals("GenericTimeSeriesDataQuery")) {
            return QUERY;
        }
        if (messageType.equals("StructureSpecificTimeSeriesDataQuery")) {
            return QUERY;
        }
        if (messageType.equals("GenericMetadataQuery")) {
            return QUERY;
        }
        if (messageType.equals("StructureSpecificMetadataQuery")) {
            return QUERY;
        }
        if (messageType.equals("StructuresQuery")) {
            return QUERY;
        }
        if (messageType.equals("DataflowQuery")) {
            return QUERY;
        }
        if (messageType.equals("MetadataflowQuery")) {
            return QUERY;
        }
        if (messageType.equals("DataStructureQuery")) {
            return QUERY;
        }
        if (messageType.equals("MetadataStructureQuery")) {
            return QUERY;
        }
        if (messageType.equals("CategorySchemeQuery")) {
            return QUERY;
        }
        if (messageType.equals("ConceptSchemeQuery")) {
            return QUERY;
        }
        if (messageType.equals("CodelistQuery")) {
            return QUERY;
        }
        if (messageType.equals("HierarchicalCodelistQuery")) {
            return QUERY;
        }
        if (messageType.equals("OrganisationSchemeQuery")) {
            return QUERY;
        }
        if (messageType.equals("ReportingTaxonomyQuery")) {
            return QUERY;
        }
        if (messageType.equals("StructureSetQuery")) {
            return QUERY;
        }
        if (messageType.equals("ProcessQuery")) {
            return QUERY;
        }
        if (messageType.equals("CategorisationQuery")) {
            return QUERY;
        }
        if (messageType.equals("ProvisionAgreementQuery")) {
            return QUERY;
        }
        if (messageType.equals("ConstraintQuery")) {
            return QUERY;
        }
        for (MESSAGE_TYPE currentType : MESSAGE_TYPE.values()) {
            if (!currentType.getNodeName().equalsIgnoreCase(messageType)) continue;
            return currentType;
        }
        throw new IllegalArgumentException("'" + messageType + "' is not a known root node for an SDMX message");
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isData() {
        return this == COMPACT_DATA || this == GENERIC_DATA || this == UTILITY_DATA || this == CROSS_SECTIONAL_DATA || this == SDMX_EDI;
    }
}

