/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

import org.sdmxsource.sdmx.api.constants.ARTIFACT_TYPE;

public enum REGISTRY_MESSAGE_TYPE {
    SUBMIT_STRUCTURE_REQUEST(ARTIFACT_TYPE.STRUCTURE, "SubmitStructureRequest", null),
    SUBMIT_PROVISION_REQUEST(ARTIFACT_TYPE.PROVISION, "SubmitProvisioningRequest", null),
    SUBMIT_REGISTRATION_REQUEST(ARTIFACT_TYPE.REGISTRATION, "SubmitRegistrationRequest", "SubmitRegistrationsRequest"),
    SUBMIT_SUBSCRIPTION_REQUEST(ARTIFACT_TYPE.SUBSCRIPTION, "SubmitSubscriptionRequest", "SubmitSubscriptionsRequest"),
    QUERY_STRUCTURE_REQUEST(ARTIFACT_TYPE.STRUCTURE, "QueryStructureRequest", null),
    QUERY_PROVISION_REQUEST(ARTIFACT_TYPE.PROVISION, "QueryProvisioningRequest", null),
    QUERY_REGISTRATION_REQUEST(ARTIFACT_TYPE.REGISTRATION, "QueryRegistrationRequest", null),
    SUBMIT_STRUCTURE_RESPONSE(ARTIFACT_TYPE.STRUCTURE, "SubmitStructureResponse", null),
    SUBMIT_PROVISION_RESPONSE(ARTIFACT_TYPE.PROVISION, "SubmitProvisioningResponse", null),
    SUBMIT_REGISTRATION_RESPONSE(ARTIFACT_TYPE.REGISTRATION, "SubmitRegistrationResponse", "SubmitRegistrationsResponse"),
    SUBMIT_SUBSCRIPTION_RESPONSE(ARTIFACT_TYPE.SUBSCRIPTION, "SubmitSubscriptionResponse", "SubmitSubscriptionsResponse"),
    QUERY_PROVISION_RESPONSE(ARTIFACT_TYPE.PROVISION, "QueryProvisioningResponse", null),
    QUERY_REGISTRATION_RESPONSE(ARTIFACT_TYPE.REGISTRATION, "QueryRegistrationResponse", null),
    QUERY_STRUCTURE_RESPONSE(ARTIFACT_TYPE.STRUCTURE, "QueryStructureResponse", null),
    NOTIFY_REGISTRY_EVENT(ARTIFACT_TYPE.NOTIFICATION, "NotifyRegistryEvent", null);

    private ARTIFACT_TYPE artifactType;
    private String type;
    private String twoPointOneType;

    private REGISTRY_MESSAGE_TYPE(ARTIFACT_TYPE artifactType, String type, String twoPointOneType) {
        this.artifactType = artifactType;
        this.type = type;
        this.twoPointOneType = twoPointOneType;
        if (this.twoPointOneType == null) {
            this.twoPointOneType = type;
        }
    }

    public static REGISTRY_MESSAGE_TYPE getMessageType(String XMLNode) {
        for (REGISTRY_MESSAGE_TYPE currentType : REGISTRY_MESSAGE_TYPE.values()) {
            if (!currentType.getType().equals(XMLNode) && !currentType.twoPointOneType.equals(XMLNode)) continue;
            return currentType;
        }
        throw new IllegalArgumentException("Unknown node :" + XMLNode);
    }

    public ARTIFACT_TYPE getArtifactType() {
        return this.artifactType;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNotifyEvent() {
        return this == NOTIFY_REGISTRY_EVENT;
    }

    public boolean isSubmissionRequest() {
        return this == SUBMIT_STRUCTURE_REQUEST || this == SUBMIT_PROVISION_REQUEST || this == SUBMIT_REGISTRATION_REQUEST || this == SUBMIT_SUBSCRIPTION_REQUEST;
    }

    public boolean isSubmissionResponse() {
        return this == SUBMIT_STRUCTURE_RESPONSE || this == SUBMIT_PROVISION_RESPONSE || this == SUBMIT_REGISTRATION_RESPONSE || this == SUBMIT_SUBSCRIPTION_RESPONSE;
    }

    public boolean isQueryRequest() {
        return this == QUERY_PROVISION_REQUEST || this == QUERY_REGISTRATION_REQUEST || this == QUERY_STRUCTURE_REQUEST;
    }

    public boolean isQueryResponse() {
        return this == QUERY_PROVISION_RESPONSE || this == QUERY_REGISTRATION_RESPONSE || this == QUERY_STRUCTURE_RESPONSE;
    }
}

