/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

public enum SDMX_ERROR_CODE {
    NO_RESULTS_FOUND(100, "No Results Found", 404),
    UNAUTHORISED(110, "Unauthorized", 401),
    RESPONSE_TOO_LARGE(130, "ResponseToo Large", 413),
    SYNTAX_ERROR(140, "Syntax Error", 400),
    SEMANTIC_ERROR(150, "Semantic Error", 400),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error", 500),
    NOT_IMPLEMENTED(501, "Not Implemented", 501),
    SERVICE_UNAVAILABLE(503, "Service Unavailable", 503),
    RESPONSE_SIZE_EXCEEDS_SERVICE_LIMIT(510, "Response size exceeds service limit", 413);

    private Integer clientErrorCode;
    private String errorString;
    private Integer httpRestErrorCode;

    private SDMX_ERROR_CODE(Integer clientErrorCode, String errorString, int httpRestErrorCode) {
        this.clientErrorCode = clientErrorCode;
        this.errorString = errorString;
        this.httpRestErrorCode = httpRestErrorCode;
    }

    public static SDMX_ERROR_CODE parseClientCode(int code) {
        for (SDMX_ERROR_CODE currentCode : SDMX_ERROR_CODE.values()) {
            if (currentCode.getClientErrorCode() != code) continue;
            return currentCode;
        }
        return null;
    }

    public Integer getClientErrorCode() {
        return this.clientErrorCode;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public Integer getHttpRestErrorCode() {
        return this.httpRestErrorCode;
    }
}

