/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;

public class SdmxConstants {
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String GENERIC_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/generic";
    public static final String MESSAGE_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message";
    public static final String COMPACT_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/compact";
    public static final String UTILITY_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/utility";
    public static final String CROSS_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/cross";
    public static final String COMMON_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/common";
    public static final String QUERY_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/query";
    public static final String REGISTRY_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/registry";
    public static final String STRUCTURE_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/structure";
    public static final String GENERICMETADATA_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/genericmetadata";
    public static final String METADATAREPORT_NS_1_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/metadatareport";
    public static final String GENERIC_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/generic";
    public static final String MESSAGE_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message";
    public static final String COMPACT_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/compact";
    public static final String UTILITY_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/utility";
    public static final String CROSS_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/cross";
    public static final String COMMON_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/common";
    public static final String QUERY_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/query";
    public static final String REGISTRY_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/registry";
    public static final String STRUCTURE_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/structure";
    public static final String GENERICMETADATA_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/genericmetadata";
    public static final String METADATAREPORT_NS_2_0 = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/metadatareport";
    public static final String GENERIC_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/generic";
    public static final String MESSAGE_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/message";
    public static final String COMPACT_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/compact";
    public static final String UTILITY_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/utility";
    public static final String CROSS_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/cross";
    public static final String COMMON_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/common";
    public static final String QUERY_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/query";
    public static final String REGISTRY_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/registry";
    public static final String STRUCTURE_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/structure";
    public static final String GENERICMETADATA_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/genericmetadata";
    public static final String METADATAREPORT_NS_2_0_REGISTRY = "http://metadatatechnology.com/sdmx/registry/schemas/v2_0/metadatareport";
    public static final String GENERIC_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic";
    public static final String MESSAGE_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message";
    public static final String COMPACT_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/structurespecific";
    public static final String COMMON_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/common";
    public static final String QUERY_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/query";
    public static final String REGISTRY_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/registry";
    public static final String STRUCTURE_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/structure";
    public static final String GENERICMETADATA_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/genericmetadata";
    public static final String METADATAREPORT_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/metadatareport";
    public static final String STRUCTURE_SPECIFIC_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific";
    public static final String ERROR_NS_2_1 = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message";
    public static final String GENERIC_DATA_ROOT_NODE = "GenericData";
    public static final String UTILITY_DATA_ROOT_NODE = "UtilityData";
    public static final String COMPACT_DATA_ROOT_NODE = "CompactData";
    public static final String CROSS_SECTIONAL_DATA_ROOT_NODE = "CrossSectionalData";
    public static final String MESSAGE_GROUP_ROOT_NODE = "MessageGroup";
    public static final String STRUCTURE_SPECIFIC_TIME_SERIES_DATA = "StructureSpecificTimeSeriesData";
    public static final String STRUCTURE_SPECIFIC_DATA = "StructureSpecificData";
    public static final String GENERIC_TIME_SERIES_DATA_ROOT_NODE = "GenericTimeSeriesData";
    public static final String STRUCTURE_ROOT_NODE = "Structure";
    public static final String REGISTRY_INTERFACE_ROOT_NODE = "RegistryInterface";
    public static final String QUERY_MESSAGE_ROOT_NODE = "QueryMessage";
    public static final String MISSING_DATA_VALUE = "NaN";
    public static final String REST_WILDCARD = "*";
    private static final Map<String, String> v1Tov2Map = new HashMap<String, String>();
    private static final Map<String, String> v2Tov1Map;
    private static final Map<String, String> namespaceToSchema;

    public static String getSchemaName(String schemaURI) {
        return namespaceToSchema.get(schemaURI);
    }

    public static boolean isKnownNamespace(String uri) {
        return SdmxConstants.getNamespacesV1().contains(uri) || SdmxConstants.getNamespacesV2().contains(uri) || SdmxConstants.getNamespacesV2_1().contains(uri) || SdmxConstants.getNamespacesV2Registry().contains(uri);
    }

    public static SDMX_SCHEMA getSchemaVersion(String uri) {
        if (SdmxConstants.getNamespacesV1().contains(uri)) {
            return SDMX_SCHEMA.VERSION_ONE;
        }
        if (SdmxConstants.getNamespacesV2().contains(uri)) {
            return SDMX_SCHEMA.VERSION_TWO;
        }
        if (SdmxConstants.getNamespacesV2_1().contains(uri)) {
            return SDMX_SCHEMA.VERSION_TWO_POINT_ONE;
        }
        throw new IllegalArgumentException("Unknown schema URI: " + uri);
    }

    public static String switchNamespaceURI(String inputNamespace, SDMX_SCHEMA schemaVersion) {
        if (SdmxConstants.getNamespacesV1().contains(inputNamespace)) {
            return SdmxConstants.switchNamespace(SDMX_SCHEMA.VERSION_ONE, schemaVersion, inputNamespace);
        }
        if (SdmxConstants.getNamespacesV2().contains(inputNamespace)) {
            return SdmxConstants.switchNamespace(SDMX_SCHEMA.VERSION_TWO, schemaVersion, inputNamespace);
        }
        if (SdmxConstants.getNamespacesV2_1().contains(inputNamespace)) {
            return SdmxConstants.switchNamespace(SDMX_SCHEMA.VERSION_TWO_POINT_ONE, schemaVersion, inputNamespace);
        }
        throw new IllegalArgumentException("unknown namespace : " + inputNamespace);
    }

    private static String switchNamespace(SDMX_SCHEMA inputFormat, SDMX_SCHEMA outputFormat, String namespaceURI) {
        switch (inputFormat) {
            case VERSION_ONE: {
                switch (outputFormat) {
                    case VERSION_ONE: {
                        return namespaceURI;
                    }
                    case VERSION_TWO: {
                        return v1Tov2Map.get(namespaceURI);
                    }
                    case VERSION_TWO_POINT_ONE: {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "2.1");
                    }
                }
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{outputFormat});
            }
            case VERSION_TWO: {
                switch (outputFormat) {
                    case VERSION_ONE: {
                        return v2Tov1Map.get(namespaceURI);
                    }
                    case VERSION_TWO: {
                        return namespaceURI;
                    }
                    case VERSION_TWO_POINT_ONE: {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, "2.1");
                    }
                }
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{outputFormat});
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{outputFormat});
    }

    public static Map<String, String> getV2toV1Map() {
        return new HashMap<String, String>(v2Tov1Map);
    }

    public static Map<String, String> getV1toV2Map() {
        return new HashMap<String, String>(v1Tov2Map);
    }

    public static List<String> getNamespacesV1() {
        ArrayList<String> allNamespaces = new ArrayList<String>();
        allNamespaces.add(GENERIC_NS_1_0);
        allNamespaces.add(MESSAGE_NS_1_0);
        allNamespaces.add(COMPACT_NS_1_0);
        allNamespaces.add(UTILITY_NS_1_0);
        allNamespaces.add(CROSS_NS_1_0);
        allNamespaces.add(COMMON_NS_1_0);
        allNamespaces.add(QUERY_NS_1_0);
        allNamespaces.add(REGISTRY_NS_1_0);
        allNamespaces.add(STRUCTURE_NS_1_0);
        allNamespaces.add(GENERICMETADATA_NS_1_0);
        allNamespaces.add(METADATAREPORT_NS_1_0);
        return allNamespaces;
    }

    public static List<String> getNamespacesV2() {
        ArrayList<String> allNamespaces = new ArrayList<String>();
        allNamespaces.add(GENERIC_NS_2_0);
        allNamespaces.add(MESSAGE_NS_2_0);
        allNamespaces.add(COMPACT_NS_2_0);
        allNamespaces.add(UTILITY_NS_2_0);
        allNamespaces.add(CROSS_NS_2_0);
        allNamespaces.add(COMMON_NS_2_0);
        allNamespaces.add(QUERY_NS_2_0);
        allNamespaces.add(REGISTRY_NS_2_0);
        allNamespaces.add(STRUCTURE_NS_2_0);
        allNamespaces.add(GENERICMETADATA_NS_2_0);
        allNamespaces.add(METADATAREPORT_NS_2_0);
        return allNamespaces;
    }

    public static List<String> getNamespacesV2_1() {
        ArrayList<String> allNamespaces = new ArrayList<String>();
        allNamespaces.add(GENERIC_NS_2_1);
        allNamespaces.add("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message");
        allNamespaces.add(COMPACT_NS_2_1);
        allNamespaces.add(COMMON_NS_2_1);
        allNamespaces.add(QUERY_NS_2_1);
        allNamespaces.add(REGISTRY_NS_2_1);
        allNamespaces.add(STRUCTURE_NS_2_1);
        allNamespaces.add(GENERICMETADATA_NS_2_1);
        allNamespaces.add(METADATAREPORT_NS_2_1);
        allNamespaces.add("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message");
        return allNamespaces;
    }

    public static List<String> getNamespacesV2Registry() {
        ArrayList<String> allNamespaces = new ArrayList<String>();
        allNamespaces.add(GENERIC_NS_2_0_REGISTRY);
        allNamespaces.add(MESSAGE_NS_2_0_REGISTRY);
        allNamespaces.add(COMPACT_NS_2_0_REGISTRY);
        allNamespaces.add(UTILITY_NS_2_0_REGISTRY);
        allNamespaces.add(CROSS_NS_2_0_REGISTRY);
        allNamespaces.add(COMMON_NS_2_0_REGISTRY);
        allNamespaces.add(QUERY_NS_2_0_REGISTRY);
        allNamespaces.add(REGISTRY_NS_2_0_REGISTRY);
        allNamespaces.add(STRUCTURE_NS_2_0_REGISTRY);
        allNamespaces.add(GENERICMETADATA_NS_2_0_REGISTRY);
        allNamespaces.add(METADATAREPORT_NS_2_0_REGISTRY);
        return allNamespaces;
    }

    static {
        v1Tov2Map.put(GENERIC_NS_1_0, GENERIC_NS_2_0);
        v1Tov2Map.put(MESSAGE_NS_1_0, MESSAGE_NS_2_0);
        v1Tov2Map.put(COMPACT_NS_1_0, COMPACT_NS_2_0);
        v1Tov2Map.put(UTILITY_NS_1_0, UTILITY_NS_2_0);
        v1Tov2Map.put(CROSS_NS_1_0, CROSS_NS_2_0);
        v1Tov2Map.put(COMMON_NS_1_0, COMMON_NS_2_0);
        v1Tov2Map.put(QUERY_NS_1_0, QUERY_NS_2_0);
        v1Tov2Map.put(REGISTRY_NS_1_0, REGISTRY_NS_2_0);
        v1Tov2Map.put(STRUCTURE_NS_1_0, STRUCTURE_NS_2_0);
        v1Tov2Map.put(GENERICMETADATA_NS_1_0, GENERICMETADATA_NS_2_0);
        v1Tov2Map.put(METADATAREPORT_NS_1_0, METADATAREPORT_NS_2_0);
        v2Tov1Map = new HashMap<String, String>();
        v2Tov1Map.put(GENERIC_NS_2_0, GENERIC_NS_1_0);
        v2Tov1Map.put(MESSAGE_NS_2_0, MESSAGE_NS_1_0);
        v2Tov1Map.put(COMPACT_NS_2_0, COMPACT_NS_1_0);
        v2Tov1Map.put(UTILITY_NS_2_0, UTILITY_NS_1_0);
        v2Tov1Map.put(CROSS_NS_2_0, CROSS_NS_1_0);
        v2Tov1Map.put(COMMON_NS_2_0, COMMON_NS_1_0);
        v2Tov1Map.put(QUERY_NS_2_0, QUERY_NS_1_0);
        v2Tov1Map.put(REGISTRY_NS_2_0, REGISTRY_NS_1_0);
        v2Tov1Map.put(STRUCTURE_NS_2_0, STRUCTURE_NS_1_0);
        v2Tov1Map.put(GENERICMETADATA_NS_2_0, GENERICMETADATA_NS_1_0);
        v2Tov1Map.put(METADATAREPORT_NS_2_0, METADATAREPORT_NS_1_0);
        namespaceToSchema = new HashMap<String, String>();
        namespaceToSchema.put(COMMON_NS_1_0, "SDMXCommon.xsd");
        namespaceToSchema.put(COMMON_NS_2_0, "SDMXCommon.xsd");
        namespaceToSchema.put(COMMON_NS_2_1, "SDMXCommon.xsd");
        namespaceToSchema.put(MESSAGE_NS_1_0, "SDMXMessage.xsd");
        namespaceToSchema.put(MESSAGE_NS_2_0, "SDMXMessage.xsd");
        namespaceToSchema.put("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message", "SDMXMessage.xsd");
        namespaceToSchema.put("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message", "SDMXMessage.xsd");
        namespaceToSchema.put(GENERIC_NS_1_0, "SDMXGenericData.xsd");
        namespaceToSchema.put(GENERIC_NS_2_0, "SDMXGenericData.xsd");
        namespaceToSchema.put(GENERIC_NS_2_1, "SDMXDataGeneric.xsd");
        namespaceToSchema.put(COMPACT_NS_1_0, "SDMXCompactData.xsd");
        namespaceToSchema.put(COMPACT_NS_2_0, "SDMXCompactData.xsd");
        namespaceToSchema.put(COMPACT_NS_2_1, "SDMXDataStructureSpecific.xsd");
        namespaceToSchema.put(UTILITY_NS_1_0, "SDMXUtilityData.xsd");
        namespaceToSchema.put(UTILITY_NS_2_0, "SDMXUtilityData.xsd");
        namespaceToSchema.put(CROSS_NS_1_0, "SDMXCrossSectionalData.xsd");
        namespaceToSchema.put(CROSS_NS_2_0, "SDMXCrossSectionalData.xsd");
        namespaceToSchema.put(QUERY_NS_1_0, "SDMXQuery.xsd");
        namespaceToSchema.put(QUERY_NS_2_0, "SDMXQuery.xsd");
        namespaceToSchema.put(QUERY_NS_2_1, "SDMXQuery.xsd");
        namespaceToSchema.put(REGISTRY_NS_1_0, "SDMXRegistry.xsd");
        namespaceToSchema.put(REGISTRY_NS_2_0, "SDMXRegistry.xsd");
        namespaceToSchema.put(REGISTRY_NS_2_1, "SDMXRegistry.xsd");
        namespaceToSchema.put(STRUCTURE_NS_1_0, "SDMXStructure.xsd");
        namespaceToSchema.put(STRUCTURE_NS_2_0, "SDMXStructure.xsd");
        namespaceToSchema.put(STRUCTURE_NS_2_1, "SDMXStructure.xsd");
        namespaceToSchema.put(GENERICMETADATA_NS_1_0, "SDMXStructure.xsd");
        namespaceToSchema.put(GENERICMETADATA_NS_2_0, "SDMXGenericMetadata.xsd");
        namespaceToSchema.put(GENERICMETADATA_NS_2_1, "SDMXMetadataGeneric.xsd");
        namespaceToSchema.put(METADATAREPORT_NS_1_0, "SDMXMetadataReport.xsd");
        namespaceToSchema.put(METADATAREPORT_NS_2_0, "SDMXMetadataReport.xsd");
    }
}

