/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.exception;

import java.util.Locale;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.util.MessageResolver;

public abstract class BaseCheckedException
extends Exception {
    private static final long serialVersionUID = 1368799655413086605L;
    private static MessageResolver messageResolver;
    private ExceptionCode code;
    private String codeStr;
    private Object[] args;
    private Throwable th;

    public BaseCheckedException(String str) {
        super(str);
        this.printStackTrace();
        System.err.println(this.getMessage());
    }

    public BaseCheckedException(Throwable th, String str) {
        super(str, th);
        if (th != null) {
            th.printStackTrace();
        }
        super.printStackTrace();
        System.out.println(this.getMessage());
    }

    public BaseCheckedException(Throwable th, ExceptionCode code, Object[] args) {
        super(th);
        this.th = th;
        if (th != null) {
            th.printStackTrace();
        }
        super.printStackTrace();
        if (code != null) {
            this.code = code;
            this.codeStr = code.getCode();
        }
        this.args = args;
        System.out.println(this.getMessage());
    }

    @Override
    public String getMessage() {
        if (this.codeStr == null) {
            return super.getMessage();
        }
        return this.getMessage(this.th, this.codeStr, this.args);
    }

    public String getFullMessage() {
        if (this.codeStr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            if (this.getCause() != null) {
                sb.append("  - caused by " + System.getProperty("line.separator"));
                if (this.getCause() instanceof BaseCheckedException) {
                    sb.append(((BaseCheckedException)this.getCause()).getFullMessage());
                } else {
                    sb.append(this.getCause().getMessage());
                }
            }
            return sb.toString();
        }
        return this.getFullMessage(this.th, this.codeStr, this.args);
    }

    public String getMessage(Locale loc) {
        return this.getMessage(this.th, this.codeStr, this.args, loc);
    }

    public ExceptionCode getCode() {
        if (this.code == null && this.th != null && this.th instanceof BaseCheckedException) {
            return ((BaseCheckedException)this.th).getCode();
        }
        return this.code;
    }

    public String getMessage(Throwable th, String code, Object[] args) {
        String nestedMessage = "";
        if (code == null) {
            return nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getFullMessage(Throwable th, String code, Object[] args) {
        Object nestedMessage = "";
        if (th != null) {
            if (th instanceof BaseCheckedException) {
                BaseCheckedException ex = (BaseCheckedException)th;
                nestedMessage = "Nested Message : " + ex.getFullMessage();
            } else {
                nestedMessage = "Nested Message : " + th.getMessage();
            }
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage != null && ((String)nestedMessage).length() > 0) {
            return this.resolveMessage(code, args) + "\n\n" + (String)nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getMessage(Throwable th, String code, Object[] args, Locale loc) {
        String nestedMessage = "";
        if (th != null) {
            if (th instanceof BaseCheckedException) {
                nestedMessage = ((BaseCheckedException)th).getMessage(loc);
            }
            nestedMessage = th.getMessage();
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage != null && nestedMessage.length() > 0) {
            return this.resolveMessage(code, args, loc) + "\n\n" + nestedMessage;
        }
        return this.resolveMessage(code, args, loc);
    }

    public String resolveMessage(String code, Object[] args) {
        if (messageResolver == null) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        Locale myLoc = null;
        myLoc = Locale.ENGLISH;
        sb.append(myLoc);
        sb.append("\n\n");
        String message = messageResolver.resolveMessage(code, myLoc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " the following locales were checked: " + sb.toString();
    }

    public String resolveMessage(String code, Object[] args, Locale loc) {
        if (messageResolver == null) {
            return code;
        }
        String message = messageResolver.resolveMessage(code, loc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " for the following locale " + loc;
    }

    public abstract String getErrorType();

    public void setMessageResolver(MessageResolver messageResolver) {
        BaseCheckedException.messageResolver = messageResolver;
    }
}

