/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.exception;

import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;

public class CrossReferenceException
extends SdmxSemmanticException {
    private static final long serialVersionUID = -6635423716751086527L;
    private CrossReferenceBean crossReference;

    public CrossReferenceException(CrossReferenceBean crossReference) {
        super(ExceptionCode.REFERENCE_ERROR_UNRESOLVABLE, CrossReferenceException.getReferenceFromIdentifier(crossReference), crossReference.getTargetUrn());
        this.crossReference = crossReference;
    }

    public static String getReferenceFromIdentifier(CrossReferenceBean crossReference) {
        IdentifiableBean parentIdentifiable = crossReference.getReferencedFrom().getParent(IdentifiableBean.class, true);
        if (parentIdentifiable != null) {
            return parentIdentifiable.getUrn();
        }
        return crossReference.getReferencedFrom().toString();
    }

    public CrossReferenceBean getCrossReference() {
        return this.crossReference;
    }

    @Override
    public String getErrorType() {
        return "Reference Exception";
    }
}

