/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.factory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.factory.StructureParserFactory;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;

public class EdiStructureParserFactory
implements StructureParserFactory {
    private static final Logger LOG = LogManager.getLogger(EdiStructureParserFactory.class);
    private final EdiParseManager ediParseManager;

    public EdiStructureParserFactory(EdiParseManager ediParseManager) {
        this.ediParseManager = ediParseManager;
    }

    public SdmxBeans getSdmxBeans(ReadableDataLocation dataLocation) {
        SDMX_SCHEMA schemaVersion = null;
        try {
            schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation);
        }
        catch (Throwable th) {
            return null;
        }
        if (schemaVersion != SDMX_SCHEMA.EDI) {
            return null;
        }
        LOG.info("Parse EDI Message");
        EDIWorkspace ediWorkspace = this.ediParseManager.parseEDIMessage(dataLocation);
        if (ediWorkspace.hasStructures()) {
            return ediWorkspace.getMergedBeans();
        }
        return new SdmxBeansImpl();
    }
}

