/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.manager.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.WriteableDataLocationFactory;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.engine.EdiParseEngine;
import org.sdmxsource.sdmx.ediparser.engine.impl.EdiParseEngineImpl;
import org.sdmxsource.sdmx.ediparser.engine.reader.EDIStructureReaderEngine;
import org.sdmxsource.sdmx.ediparser.engine.reader.impl.EDIStructureReaderEngineImpl;
import org.sdmxsource.sdmx.ediparser.engine.writer.impl.EDIStructureWriterEngineImpl;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.ediparser.model.impl.EDIWorkspaceImpl;
import org.sdmxsource.util.factory.SdmxSourceWriteableDataLocationFactory;

public class EdiParseManagerImpl
implements EdiParseManager {
    private final EDIStructureReaderEngine structureReaderEngine;
    private final EdiParseEngine ediParseEngine;
    private final EDIStructureWriterEngineImpl ediStructureEngine;
    private final WriteableDataLocationFactory writeableDataLocationFactory;

    public EdiParseManagerImpl() {
        this(null, null, null, null);
    }

    public EdiParseManagerImpl(WriteableDataLocationFactory writeableDataLocationFactory, EDIStructureReaderEngine structureReaderEngine, EdiParseEngine ediParseEngine, EDIStructureWriterEngineImpl ediStructureEngine) {
        this.writeableDataLocationFactory = writeableDataLocationFactory != null ? writeableDataLocationFactory : new SdmxSourceWriteableDataLocationFactory();
        this.structureReaderEngine = structureReaderEngine != null ? structureReaderEngine : new EDIStructureReaderEngineImpl();
        this.ediParseEngine = ediParseEngine != null ? ediParseEngine : new EdiParseEngineImpl();
        this.ediStructureEngine = ediStructureEngine;
    }

    @Override
    public EDIWorkspace parseEDIMessage(ReadableDataLocation ediMessageLocation) {
        return new EDIWorkspaceImpl(this.writeableDataLocationFactory, this.structureReaderEngine, this.ediParseEngine, ediMessageLocation);
    }

    @Override
    public void writeToEDI(SdmxBeans beans, OutputStream out) {
        Objects.requireNonNull(this.ediStructureEngine, "ediStructureEngine");
        this.validateSupport(beans);
        this.ediStructureEngine.writeToEDI(beans, out);
    }

    private void validateSupport(SdmxBeans beans) {
        ArrayList<SDMX_STRUCTURE_TYPE> supportedStructres = new ArrayList<SDMX_STRUCTURE_TYPE>();
        supportedStructres.add(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.DSD);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
        supportedStructres.add(SDMX_STRUCTURE_TYPE.CODE_LIST);
        for (MaintainableBean maintainableBean : beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0])) {
            if (supportedStructres.contains(maintainableBean.getStructureType())) continue;
            throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{maintainableBean.getStructureType().getType() + " is not a supported by SDMX-EDI"});
        }
    }
}

