/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.factory.WriteableDataLocationFactory;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.engine.EdiParseEngine;
import org.sdmxsource.sdmx.ediparser.engine.reader.EDIStructureReaderEngine;
import org.sdmxsource.sdmx.ediparser.engine.reader.impl.EDIDataReaderEngineImpl;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDataDocument;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDocumentPosition;
import org.sdmxsource.sdmx.ediparser.model.document.EDIMetadata;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIDataDocumentImpl;
import org.sdmxsource.sdmx.ediparser.model.document.impl.EDIStructureDocumentImpl;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIDataReader;
import org.sdmxsource.sdmx.ediparser.model.reader.impl.FileReaderImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.PartyBeanImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;

public class EDIWorkspaceImpl
implements EDIWorkspace {
    private final WriteableDataLocationFactory writeableDataLocationFactory;
    private List<EDIDataDocument> dataDocuments = new ArrayList<EDIDataDocument>();
    private List<SdmxBeans> beans = new ArrayList<SdmxBeans>();
    private Set<MaintainableRefBean> keyFamilyReferences = new HashSet<MaintainableRefBean>();
    private EDIMetadata ediMetadata;
    private HeaderBean headerBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EDIWorkspaceImpl(WriteableDataLocationFactory writeableDataLocationFactory, EDIStructureReaderEngine structureReaderEngine, EdiParseEngine ediParseEngine, ReadableDataLocation ediDocument) {
        this.writeableDataLocationFactory = Objects.requireNonNull(writeableDataLocationFactory, "writeableDataLocationFactory");
        this.ediMetadata = Objects.requireNonNull(ediParseEngine, "ediParseEngine").parseEDIMessage(ediDocument);
        int idx = 0;
        try (FileReaderImpl fr = new FileReaderImpl(ediDocument, "(?<!\\?)\\'", "ISO-8859-1");){
            for (EDIDocumentPosition documentPosition : this.ediMetadata.getDocumentIndex()) {
                OutputStreamWriter osw;
                int start = documentPosition.getStartLine();
                WriteableDataLocation wdl = writeableDataLocationFactory.getTemporaryWriteableDataLocation();
                try {
                    osw = new OutputStreamWriter(wdl.getOutputStream(), "ISO-8859-1");
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException("Unable to open: ", e1);
                }
                while (fr.moveNext()) {
                    idx = fr.getLineNumber();
                    if (idx < start) continue;
                    String line = fr.getCurrentLine();
                    this.write(osw, line + "'");
                    if (!line.startsWith(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString())) continue;
                    break;
                }
                try {
                    osw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close: ", e);
                }
                if (documentPosition.isData()) {
                    EDIDataDocumentImpl dataDocument = new EDIDataDocumentImpl((ReadableDataLocation)wdl, documentPosition, this.ediMetadata);
                    this.dataDocuments.add(dataDocument);
                    this.keyFamilyReferences.add(dataDocument.getDataReader().getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference());
                    continue;
                }
                EDIStructureDocumentImpl doc = new EDIStructureDocumentImpl(structureReaderEngine, (ReadableDataLocation)wdl, documentPosition, this.ediMetadata);
                try {
                    this.beans.add(doc.getSdmxBeans());
                }
                finally {
                    wdl.close();
                }
            }
            this.createHeader();
        }
    }

    private void write(OutputStreamWriter outputStreamWriter, String value) {
        try {
            outputStreamWriter.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the string: " + value, e);
        }
    }

    private void createHeader() {
        ArrayList<DatasetStructureReferenceBean> structure = new ArrayList<DatasetStructureReferenceBean>();
        ArrayList<PartyBeanImpl> receiver = new ArrayList<PartyBeanImpl>();
        PartyBean sender = null;
        HashSet<String> allreceivers = new HashSet<String>();
        for (EDIDataDocument currentReader : this.dataDocuments) {
            EDIDataReader reader = currentReader.getDataReader();
            DatasetHeaderBean header = reader.getDatasetHeaderBean();
            structure.add(header.getDataStructureReference());
            sender = reader.getSendingAgency();
            String recievingAgency = reader.getRecievingAgency();
            if (allreceivers.contains(recievingAgency)) continue;
            allreceivers.add(recievingAgency);
            receiver.add(new PartyBeanImpl(null, recievingAgency, null, null));
        }
        this.headerBean = new HeaderBeanImpl(this.ediMetadata.getInterchangeReference(), this.ediMetadata.getDateOfPreparation(), this.ediMetadata.getReportingBegin(), this.ediMetadata.getReportingEnd(), receiver, sender, this.ediMetadata.isTest());
        if (this.ediMetadata.getMessageName() != null) {
            this.headerBean.addName((TextTypeWrapper)new TextTypeWrapperImpl("en", this.ediMetadata.getMessageName(), null));
        }
    }

    @Override
    public HeaderBean getHeader() {
        return this.headerBean;
    }

    @Override
    public List<DatasetHeaderBean> getDatasetHeaders() {
        ArrayList<DatasetHeaderBean> returnList = new ArrayList<DatasetHeaderBean>();
        for (EDIDataDocument currentReader : this.dataDocuments) {
            EDIDataReader reader = currentReader.getDataReader();
            DatasetHeaderBean header = reader.getDatasetHeaderBean();
            returnList.add(header);
        }
        return returnList;
    }

    @Override
    public DataReaderEngine getDataReader(SdmxBeanRetrievalManager beanRetrieval) {
        ArrayList<EDIDataReader> engines = new ArrayList<EDIDataReader>();
        for (EDIDataDocument dataDocument : this.dataDocuments) {
            engines.add(dataDocument.getDataReader());
        }
        return new EDIDataReaderEngineImpl(this.headerBean, beanRetrieval, engines);
    }

    @Override
    public DataReaderEngine getDataReader(DataStructureBean keyFamily, DataflowBean dataflowBean) {
        if (!this.hasData()) {
            throw new IllegalArgumentException("Attempting to read data from an EDI file that does not contain data");
        }
        if (!this.keyFamilyReferences.contains(keyFamily.asReference().getMaintainableReference())) {
            return null;
        }
        ArrayList<EDIDataReader> engines = new ArrayList<EDIDataReader>();
        for (EDIDataDocument dataDocument : this.dataDocuments) {
            if (!dataDocument.getDataReader().getDatasetHeaderBean().getDataStructureReference().getStructureReference().getMaintainableReference().equals(keyFamily.asReference().getMaintainableReference())) continue;
            engines.add(dataDocument.getDataReader());
        }
        return new EDIDataReaderEngineImpl(this.headerBean, dataflowBean, keyFamily, engines);
    }

    public List<EDIDataDocument> getEDIDataDocument() {
        return new ArrayList<EDIDataDocument>(this.dataDocuments);
    }

    @Override
    public List<SdmxBeans> getBeans() {
        return new ArrayList<SdmxBeans>(this.beans);
    }

    @Override
    public SdmxBeans getMergedBeans() {
        if (!this.hasStructures()) {
            throw new RuntimeException("There are no structures within this EDI file.");
        }
        if (this.beans.size() == 1) {
            return this.beans.get(0);
        }
        SdmxBeansImpl returnBeans = new SdmxBeansImpl(this.headerBean);
        for (SdmxBeans currentBeans : this.beans) {
            returnBeans.merge(currentBeans);
        }
        return returnBeans;
    }

    @Override
    public boolean hasData() {
        return this.dataDocuments.size() > 0;
    }

    @Override
    public boolean hasStructures() {
        return this.beans.size() > 0;
    }
}

